/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.key.ISecretCryptographyKey;

public class ValidityKey
extends ACryptographyKey<Void>
implements IPublicCryptographyKey<Void>,
ISecretCryptographyKey<Void> {
    public static final ValidityKey errorSmimeKey() {
        return ValidityKey.key(EKeyValidity.ERROR, ECryptographyType.SMIME);
    }

    public static final ValidityKey invalidSmimeKey() {
        return ValidityKey.key(EKeyValidity.INVALID, ECryptographyType.SMIME);
    }

    public static final ValidityKey notFoundSmimeKey() {
        return ValidityKey.key(EKeyValidity.NOT_FOUND, ECryptographyType.SMIME);
    }

    public static final ValidityKey errorPgpKey() {
        return ValidityKey.key(EKeyValidity.ERROR, ECryptographyType.PGP);
    }

    public static final ValidityKey invalidPgpKey() {
        return ValidityKey.key(EKeyValidity.INVALID, ECryptographyType.PGP);
    }

    public static final ValidityKey notFoundPgpKey() {
        return ValidityKey.key(EKeyValidity.NOT_FOUND, ECryptographyType.PGP);
    }

    public static final ValidityKey key(EKeyValidity validity, ECryptographyType cryptography) {
        if (validity == null) {
            throw new IllegalArgumentException("Validity must not be null.");
        }
        if (validity == EKeyValidity.VALID) {
            throw new IllegalArgumentException("This method cannot be used to create a valid key.");
        }
        ValidityKey key = new ValidityKey(null, cryptography);
        key.setKeyValidity(validity);
        return key;
    }

    private ValidityKey(EKeyPurpose keyPurpose, ECryptographyType cryptography) {
        super(keyPurpose, cryptography);
    }

    @Override
    public Void getKey() {
        return null;
    }
}

