/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.smtp;

import com.sun.mail.smtp.SMTPSSLTransport;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.security.ClassLoaderEnforcer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.confluence.mailer.ConfluenceMailer;
import net.savignano.snotify.confluence.mailer.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifySmtpsTransport
extends SMTPSSLTransport {
    private static final Logger log = LoggerFactory.getLogger(SnotifySmtpsTransport.class);
    private final ConfluenceMailer mailer;

    public SnotifySmtpsTransport(Session session, URLName urlname) {
        super(session, urlname);
        log.info("Using S/Notify SMTPS transport implementation to send emails.");
        log.trace("Session properties used: {}", (Object)session.getProperties());
        this.mailer = new ConfluenceMailer(session, PropertiesUtil.getAppProps(), PropertiesUtil.getUserProps(), PropertiesUtil.getSpaceProps());
    }

    public synchronized void sendMessage(Message message, Address[] addresses) throws MessagingException {
        if (!SecurityUtil.checkSelfIntegrity()) {
            log.error("Signature of S/Notify is not correct. To protect underlying system, S/Notify will be disabled, as it has been tampered with.");
            super.sendMessage(message, addresses);
            return;
        }
        if (!(message instanceof MimeMessage)) {
            log.error("Can't encrypt email, because it is not a MIME email but: " + message.getClass().getCanonicalName());
            throw new MessagingException("Can't send email with message number " + message.getMessageNumber() + ". It is not a MIME email.");
        }
        ClassLoaderEnforcer enforcer = new ClassLoaderEnforcer(((Object)((Object)this)).getClass().getClassLoader());
        enforcer.run((t, u) -> {
            try {
                this.sendMessageToAddresses((Message)t, (Address[])u);
            }
            catch (MessagingException e1) {
                enforcer.setException((Exception)((Object)e1));
            }
        }, message, addresses);
        if (enforcer.getException() != null) {
            throw (MessagingException)((Object)enforcer.getException());
        }
    }

    private void sendMessageToAddresses(Message message, Address[] addresses) throws MessagingException {
        MessageAndAddress[] result;
        try {
            result = this.mailer.getMessages((MimeMessage)message, addresses);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new MessagingException("Error generating emails: " + e.getMessage(), e);
        }
        this.sendMessages(result);
    }

    private void sendMessages(MessageAndAddress[] emails) throws MessagingException {
        MessagingException e = null;
        for (MessageAndAddress email : emails) {
            if (email == null || email.message == null || email.address == null) continue;
            try {
                if (Boolean.parseBoolean(email.message.getHeader("X-Do-Not-Send", null))) {
                    log.info("Not delivering email to \"{}\", as S/Notify's ignore header was set.", (Object)email.address);
                    continue;
                }
                log.debug("Delivering email to: \"{}\"", (Object)email.address);
                super.sendMessage((Message)email.message, new Address[]{email.address});
            }
            catch (MessagingException e1) {
                log.error(e1.getMessage(), (Throwable)e1);
                if (e != null) continue;
                e = e1;
            }
        }
        if (e != null) {
            throw new MessagingException("Error sending mail: " + e.getMessage(), e);
        }
    }
}

