/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ApplicationSpecificParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Exception;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObjectParser;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERApplicationSpecific;
import net.savignano.thirdparty.org.bouncycastle.asn1.DLApplicationSpecific;

public abstract class ASN1ApplicationSpecific
extends ASN1TaggedObject
implements ASN1ApplicationSpecificParser {
    final ASN1TaggedObject taggedObject;

    public static ASN1ApplicationSpecific getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ApplicationSpecific) {
            return (ASN1ApplicationSpecific)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1ApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to construct object from byte[]: " + e.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    ASN1ApplicationSpecific(ASN1TaggedObject taggedObject) {
        super(taggedObject.explicitness, ASN1ApplicationSpecific.checkTagClass(taggedObject.tagClass), taggedObject.tagNo, taggedObject.obj);
        this.taggedObject = taggedObject;
    }

    public int getApplicationTag() {
        return this.taggedObject.getTagNo();
    }

    public byte[] getContents() {
        return this.taggedObject.getContents();
    }

    public ASN1Primitive getEnclosedObject() throws IOException {
        return this.taggedObject.getBaseObject().toASN1Primitive();
    }

    public ASN1Primitive getObject(int tagNo) throws IOException {
        return this.taggedObject.getBaseUniversal(false, tagNo);
    }

    public ASN1Encodable getObjectParser(int tag, boolean isExplicit) throws IOException {
        throw new ASN1Exception("this method only valid for CONTEXT_SPECIFIC tags");
    }

    public ASN1Encodable parseBaseUniversal(boolean declaredExplicit, int baseTagNo) throws IOException {
        return this.taggedObject.parseBaseUniversal(declaredExplicit, baseTagNo);
    }

    public ASN1Encodable parseExplicitBaseObject() throws IOException {
        return this.taggedObject.parseExplicitBaseObject();
    }

    public ASN1TaggedObjectParser parseExplicitBaseTagged() throws IOException {
        return this.taggedObject.parseExplicitBaseTagged();
    }

    public ASN1TaggedObjectParser parseImplicitBaseTagged(int baseTagClass, int baseTagNo) throws IOException {
        return this.taggedObject.parseImplicitBaseTagged(baseTagClass, baseTagNo);
    }

    public boolean hasApplicationTag(int tagNo) {
        return this.tagNo == tagNo;
    }

    public boolean hasContextTag(int tagNo) {
        return false;
    }

    public ASN1TaggedObject getTaggedObject() {
        return this.taggedObject;
    }

    public boolean isConstructed() {
        return this.taggedObject.isConstructed();
    }

    public ASN1Encodable readObject() throws IOException {
        return this.parseExplicitBaseObject();
    }

    boolean encodeConstructed() {
        return this.taggedObject.encodeConstructed();
    }

    int encodedLength(boolean withTag) throws IOException {
        return this.taggedObject.encodedLength(withTag);
    }

    void encode(ASN1OutputStream out, boolean withTag) throws IOException {
        this.taggedObject.encode(out, withTag);
    }

    String getASN1Encoding() {
        return this.taggedObject.getASN1Encoding();
    }

    ASN1Sequence rebuildConstructed(ASN1Primitive primitive) {
        return this.taggedObject.rebuildConstructed(primitive);
    }

    ASN1TaggedObject replaceTag(int tagClass, int tagNo) {
        return this.taggedObject.replaceTag(tagClass, tagNo);
    }

    ASN1Primitive toDERObject() {
        return new DERApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDERObject());
    }

    ASN1Primitive toDLObject() {
        return new DLApplicationSpecific((ASN1TaggedObject)this.taggedObject.toDLObject());
    }

    private static int checkTagClass(int tagClass) {
        if (64 != tagClass) {
            throw new IllegalArgumentException();
        }
        return tagClass;
    }
}

