/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its.jcajce;

import java.security.Key;
import java.security.Provider;
import java.security.interfaces.ECPublicKey;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.its.ETSIKeyWrapper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.IESKEMParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.JcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.EncryptedDataEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EccP256CurvePoint;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.EciesP256EncryptedKey;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class JceETSIKeyWrapper
implements ETSIKeyWrapper {
    private final ECPublicKey recipientKey;
    private final byte[] recipientHash;
    private final JcaJceHelper helper;

    private JceETSIKeyWrapper(ECPublicKey key, byte[] recipientHash, JcaJceHelper helper) {
        this.recipientKey = key;
        this.recipientHash = recipientHash;
        this.helper = helper;
    }

    public EncryptedDataEncryptionKey wrap(byte[] secretKey) {
        try {
            Cipher etsiKem = this.helper.createCipher("ETSIKEMwithSHA256");
            etsiKem.init(3, (Key)this.recipientKey, new IESKEMParameterSpec(this.recipientHash, true));
            byte[] wrappedKey = etsiKem.wrap(new SecretKeySpec(secretKey, "AES"));
            int size = (this.recipientKey.getParams().getCurve().getField().getFieldSize() + 7) / 8;
            size = wrappedKey[0] == 4 ? 2 * size + 1 : ++size;
            SubjectPublicKeyInfo pkInfo = SubjectPublicKeyInfo.getInstance(this.recipientKey.getEncoded());
            ASN1ObjectIdentifier curveID = ASN1ObjectIdentifier.getInstance(pkInfo.getAlgorithm().getParameters());
            EciesP256EncryptedKey key = EciesP256EncryptedKey.builder().setV(EccP256CurvePoint.createEncodedPoint(Arrays.copyOfRange(wrappedKey, 0, size))).setC(Arrays.copyOfRange(wrappedKey, size, size + secretKey.length)).setT(Arrays.copyOfRange(wrappedKey, size + secretKey.length, wrappedKey.length)).createEciesP256EncryptedKey();
            if (curveID.equals(SECObjectIdentifiers.secp256r1)) {
                return EncryptedDataEncryptionKey.eciesNistP256(key);
            }
            if (curveID.equals(TeleTrusTObjectIdentifiers.brainpoolP256r1)) {
                return EncryptedDataEncryptionKey.eciesBrainpoolP256r1(key);
            }
            throw new IllegalStateException("recipient key curve is not P-256 or Brainpool P256r1");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    public static class Builder {
        private final ECPublicKey recipientKey;
        private final byte[] recipientHash;
        private JcaJceHelper helper = new DefaultJcaJceHelper();

        public Builder(ECPublicKey recipientKey, byte[] recipientHash) {
            this.recipientKey = recipientKey;
            this.recipientHash = recipientHash;
        }

        public Builder setProvider(Provider provider) {
            this.helper = new ProviderJcaJceHelper(provider);
            return this;
        }

        public Builder setProvider(String providerName) {
            this.helper = new NamedJcaJceHelper(providerName);
            return this;
        }

        public JceETSIKeyWrapper build() {
            return new JceETSIKeyWrapper(this.recipientKey, this.recipientHash, this.helper);
        }
    }
}

