/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi102941.CtlCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceOfCtlCommand
extends ASN1Object {
    private final List<CtlCommand> ctlCommands;

    public SequenceOfCtlCommand(List<CtlCommand> hashedId8s) {
        this.ctlCommands = Collections.unmodifiableList(hashedId8s);
    }

    private SequenceOfCtlCommand(ASN1Sequence sequence) {
        ArrayList<CtlCommand> items = new ArrayList<CtlCommand>();
        Iterator<ASN1Encodable> it = sequence.iterator();
        while (it.hasNext()) {
            items.add(CtlCommand.getInstance(it.next()));
        }
        this.ctlCommands = Collections.unmodifiableList(items);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SequenceOfCtlCommand getInstance(Object o) {
        if (o instanceof SequenceOfCtlCommand) {
            return (SequenceOfCtlCommand)o;
        }
        if (o != null) {
            return new SequenceOfCtlCommand(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public List<CtlCommand> getCtlCommands() {
        return this.ctlCommands;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.ctlCommands.toArray(new ASN1Encodable[0]));
    }

    public static class Builder {
        private final List<CtlCommand> items = new ArrayList<CtlCommand>();

        public Builder addHashId8(CtlCommand ... items) {
            this.items.addAll(Arrays.asList(items));
            return this;
        }

        public SequenceOfCtlCommand build() {
            return new SequenceOfCtlCommand(this.items);
        }
    }
}

