/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.spec.AEADParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPSecretKeyDecryptorWithAAD;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcePBEProtectionRemoverFactory
implements PBEProtectionRemoverFactory {
    private final char[] passPhrase;
    private OperatorHelper helper = new OperatorHelper(new DefaultJcaJceHelper());
    private PGPDigestCalculatorProvider calculatorProvider;
    private JcaPGPDigestCalculatorProviderBuilder calculatorProviderBuilder;

    public JcePBEProtectionRemoverFactory(char[] passPhrase) {
        this.passPhrase = passPhrase;
        this.calculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    }

    public JcePBEProtectionRemoverFactory(char[] passPhrase, PGPDigestCalculatorProvider calculatorProvider) {
        this.passPhrase = passPhrase;
        this.calculatorProvider = calculatorProvider;
    }

    public JcePBEProtectionRemoverFactory setProvider(Provider provider) {
        this.helper = new OperatorHelper(new ProviderJcaJceHelper(provider));
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(provider);
        }
        return this;
    }

    public JcePBEProtectionRemoverFactory setProvider(String providerName) {
        this.helper = new OperatorHelper(new NamedJcaJceHelper(providerName));
        if (this.calculatorProviderBuilder != null) {
            this.calculatorProviderBuilder.setProvider(providerName);
        }
        return this;
    }

    public PBESecretKeyDecryptor createDecryptor(String protection) throws PGPException {
        if (this.calculatorProvider == null) {
            this.calculatorProvider = this.calculatorProviderBuilder.build();
        }
        if (protection.indexOf("ocb") >= 0) {
            return new PGPSecretKeyDecryptorWithAAD(this.passPhrase, this.calculatorProvider){

                public byte[] recoverKeyData(int encAlgorithm, byte[] key, byte[] iv, byte[] aad, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                    try {
                        Cipher c = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(encAlgorithm) + "/OCB/NoPadding");
                        c.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(encAlgorithm, key), new AEADParameterSpec(iv, 128, aad));
                        return c.doFinal(keyData, keyOff, keyLen);
                    }
                    catch (IllegalBlockSizeException e) {
                        throw new PGPException("illegal block size: " + e.getMessage(), e);
                    }
                    catch (BadPaddingException e) {
                        throw new PGPException("bad padding: " + e.getMessage(), e);
                    }
                    catch (InvalidAlgorithmParameterException e) {
                        throw new PGPException("invalid parameter: " + e.getMessage(), e);
                    }
                    catch (InvalidKeyException e) {
                        throw new PGPException("invalid key: " + e.getMessage(), e);
                    }
                }
            };
        }
        return new PBESecretKeyDecryptor(this.passPhrase, this.calculatorProvider){

            public byte[] recoverKeyData(int encAlgorithm, byte[] key, byte[] iv, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                try {
                    Cipher c = JcePBEProtectionRemoverFactory.this.helper.createCipher(PGPUtil.getSymmetricCipherName(encAlgorithm) + "/CBC/NoPadding");
                    c.init(2, (Key)JcaJcePGPUtil.makeSymmetricKey(encAlgorithm, key), new IvParameterSpec(iv));
                    return c.doFinal(keyData, keyOff, keyLen);
                }
                catch (IllegalBlockSizeException e) {
                    throw new PGPException("illegal block size: " + e.getMessage(), e);
                }
                catch (BadPaddingException e) {
                    throw new PGPException("bad padding: " + e.getMessage(), e);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new PGPException("invalid parameter: " + e.getMessage(), e);
                }
                catch (InvalidKeyException e) {
                    throw new PGPException("invalid key: " + e.getMessage(), e);
                }
            }
        };
    }
}

