/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.asn1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class ParSet
extends ASN1Object {
    private int t;
    private int[] h;
    private int[] w;
    private int[] k;

    private static int checkBigIntegerInIntRangeAndPositive(ASN1Encodable e) {
        ASN1Integer i = (ASN1Integer)e;
        int value = i.intValueExact();
        if (value <= 0) {
            throw new IllegalArgumentException("BigInteger not in Range: " + value);
        }
        return value;
    }

    private ParSet(ASN1Sequence seq) {
        if (seq.size() != 4) {
            throw new IllegalArgumentException("sie of seqOfParams = " + seq.size());
        }
        this.t = ParSet.checkBigIntegerInIntRangeAndPositive(seq.getObjectAt(0));
        ASN1Sequence seqOfPSh = (ASN1Sequence)seq.getObjectAt(1);
        ASN1Sequence seqOfPSw = (ASN1Sequence)seq.getObjectAt(2);
        ASN1Sequence seqOfPSK = (ASN1Sequence)seq.getObjectAt(3);
        if (seqOfPSh.size() != this.t || seqOfPSw.size() != this.t || seqOfPSK.size() != this.t) {
            throw new IllegalArgumentException("invalid size of sequences");
        }
        this.h = new int[seqOfPSh.size()];
        this.w = new int[seqOfPSw.size()];
        this.k = new int[seqOfPSK.size()];
        for (int i = 0; i < this.t; ++i) {
            this.h[i] = ParSet.checkBigIntegerInIntRangeAndPositive(seqOfPSh.getObjectAt(i));
            this.w[i] = ParSet.checkBigIntegerInIntRangeAndPositive(seqOfPSw.getObjectAt(i));
            this.k[i] = ParSet.checkBigIntegerInIntRangeAndPositive(seqOfPSK.getObjectAt(i));
        }
    }

    public ParSet(int t, int[] h, int[] w, int[] k) {
        this.t = t;
        this.h = h;
        this.w = w;
        this.k = k;
    }

    public static ParSet getInstance(Object o) {
        if (o instanceof ParSet) {
            return (ParSet)o;
        }
        if (o != null) {
            return new ParSet(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public int getT() {
        return this.t;
    }

    public int[] getH() {
        return Arrays.clone(this.h);
    }

    public int[] getW() {
        return Arrays.clone(this.w);
    }

    public int[] getK() {
        return Arrays.clone(this.k);
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector seqOfPSh = new ASN1EncodableVector();
        ASN1EncodableVector seqOfPSw = new ASN1EncodableVector();
        ASN1EncodableVector seqOfPSK = new ASN1EncodableVector();
        for (int i = 0; i < this.h.length; ++i) {
            seqOfPSh.add(new ASN1Integer(this.h[i]));
            seqOfPSw.add(new ASN1Integer(this.w[i]));
            seqOfPSK.add(new ASN1Integer(this.k[i]));
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1Integer(this.t));
        v.add(new DERSequence(seqOfPSh));
        v.add(new DERSequence(seqOfPSw));
        v.add(new DERSequence(seqOfPSK));
        return new DERSequence(v);
    }
}

