/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail;

import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.mail.ICryptographyResult;
import net.savignano.cryptography.util.MessageUtil;

public class BaseCryptographyResult
implements ICryptographyResult {
    private final MimeMessage msg;
    private final String msgId;
    private final ECryptographyType cryptoType;
    private Exception exception;

    public BaseCryptographyResult(MimeMessage msg, ECryptographyType cryptographyType) {
        this.msg = msg;
        this.cryptoType = cryptographyType;
        this.msgId = MessageUtil.getMessageId((Message)msg);
    }

    @Override
    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public MimeMessage getMessage() {
        return this.msg;
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.cryptoType;
    }

    public String getMsgId() {
        return this.msgId;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName());
        builder.append(" [msgId=");
        builder.append(this.msgId);
        builder.append(", cryptoType=");
        builder.append((Object)this.cryptoType);
        builder.append(", exception=");
        builder.append(this.exception);
        builder.append("]");
        return builder.toString();
    }
}

