/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.mail.encrypt.PgpEncryptionResult;
import net.savignano.cryptography.mail.encrypt.PgpMailEncryptor;
import net.savignano.cryptography.mail.visitor.ManipulateMessageVisitor;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.apache.commons.io.IOUtils;

public class InlinePgpMailEncryptor
extends PgpMailEncryptor {
    private boolean binaryAttachment;

    public InlinePgpMailEncryptor(Session session) {
        super(session);
    }

    @Override
    protected void encrypt(final Collection<PgpEncryptionKey> keys, final PgpEncryptionResult result) throws Exception {
        result.setSymmetricKeyAlgorithm(this.getSymmetricKeyAlgorithm(keys));
        ManipulateMessageVisitor visitor = new ManipulateMessageVisitor(){
            private final PGPPublicKey[] pgpKeys;
            {
                this.pgpKeys = keys.stream().map(PgpEncryptionKey::getKey).collect(Collectors.toList()).toArray(new PGPPublicKey[keys.size()]);
            }

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (part.isMimeType("text/plain")) {
                    this.encryptText(part);
                    this.setChanged(true);
                } else if ("attachment".equalsIgnoreCase(part.getDisposition())) {
                    if (InlinePgpMailEncryptor.this.isBinaryAttachment()) {
                        this.encryptAttachmentBinary(part);
                    } else {
                        this.encryptAttachmentArmored(part);
                    }
                    this.setChanged(true);
                }
            }

            private void encryptText(MimePart part) throws MessagingException, IOException, PGPException {
                this.getLog().debug("Found text/plain to encrypt.");
                ContentType contentType = new ContentType(part.getContentType());
                String text = (String)part.getContent();
                String charset = contentType.getParameter("charset");
                charset = charset == null ? "US-ASCII" : charset;
                byte[] encrypted = PgpUtil.encrypt(text.getBytes(charset), this.pgpKeys, result.getSymmetricKeyAlgorithm(), true, true);
                part.setText(new String(encrypted, Constants.ASCII_CHARSET), charset);
            }

            private void encryptAttachmentBinary(MimePart part) throws MessagingException, IOException, PGPException {
                this.getLog().debug("Found attachment to encrypt. Binary style.");
                String filename = part.getFileName();
                filename = filename != null ? filename + ".pgp" : "attachment.pgp";
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (InputStream is = part.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                byte[] encrypted = PgpUtil.encrypt(os.toByteArray(), this.pgpKeys, result.getSymmetricKeyAlgorithm(), false, true);
                ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encrypted, "application/octet-stream");
                part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
                part.setFileName(filename);
            }

            private void encryptAttachmentArmored(MimePart part) throws MessagingException, IOException, PGPException {
                this.getLog().debug("Found attachment to encrypt. Ascii armored style.");
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (InputStream is = part.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                byte[] encrypted = PgpUtil.encrypt(os.toByteArray(), this.pgpKeys, result.getSymmetricKeyAlgorithm(), true, true);
                ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encrypted, part.getContentType());
                part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
            }
        };
        try {
            visitor.visit(result.getMessage());
        }
        catch (Exception e) {
            result.setException(e);
        }
        if (visitor.isChanged()) {
            this.includeEncryptionHeader(result.getMessage(), PgpUtil.getSymmetricCipherName(result.getSymmetricKeyAlgorithm()));
        } else if (result.isSuccess()) {
            this.getLog().warn("Found no text/plain content part, nor an attachment in message with ID {}. Nothing was encrypted.", (Object)result.getMsgId());
        }
    }

    public boolean isBinaryAttachment() {
        return this.binaryAttachment;
    }

    public void setBinaryAttachment(boolean binaryAttachment) {
        this.binaryAttachment = binaryAttachment;
    }
}

