/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.mail.BaseCryptographyResult;
import net.savignano.cryptography.mail.encrypt.IEncryptionResult;
import net.savignano.cryptography.util.PgpUtil;

public class PgpEncryptionResult
extends BaseCryptographyResult
implements IEncryptionResult {
    private int symmetricKeyAlgorithm;

    public PgpEncryptionResult(MimeMessage msg) {
        super(msg, ECryptographyType.PGP);
    }

    public int getSymmetricKeyAlgorithm() {
        return this.symmetricKeyAlgorithm;
    }

    public void setSymmetricKeyAlgorithm(int symmetricKeyAlgorithm) {
        this.symmetricKeyAlgorithm = symmetricKeyAlgorithm;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.deleteCharAt(builder.length() - 1);
        builder.append(", symmetricKeyAlgorithm=");
        builder.append(PgpUtil.getSymmetricCipherName(this.symmetricKeyAlgorithm));
        builder.append("]");
        return builder.toString();
    }
}

