/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.validate;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.enums.EValidationType;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.cryptography.mail.BaseMailCryptography;
import net.savignano.cryptography.mail.validate.IMailValidator;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;

public abstract class AMailValidator<T extends IPublicCryptographyKey<?>>
extends BaseMailCryptography
implements IMailValidator<T> {
    protected AMailValidator(Session session, ECryptographyType cryptography) {
        super(session, cryptography);
    }

    protected abstract T getValidityKey(EKeyValidity var1);

    @Override
    public Set<EValidationType> validate(MimeMessage msg) throws IOException, MessagingException {
        EnumSet<EValidationType> validated = EnumSet.noneOf(EValidationType.class);
        if (msg == null) {
            return validated;
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId((Message)msg);
        try {
            if (!this.isSigned(msg)) {
                log.info("Message with msg ID \"{}\" is not signed.", (Object)msgId);
                return validated;
            }
        }
        catch (Exception e) {
            String errMsg = "Could not check if message with msg ID " + msgId + " is signed. Error message: " + e.getMessage();
            throw new MessagingException(errMsg, e);
        }
        log.info("Validating {} message with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        this.traceMessage(msg, "Email:\n{}");
        try {
            validated.addAll(this.doValidate(msg));
        }
        catch (Exception e) {
            String errMsg = "Could not validate message with msg ID " + msgId + ". Error message: " + e.getMessage();
            throw new MessagingException(errMsg, e);
        }
        log.info("Finished validating {} message with msg ID {}. Result: {}", new Object[]{this.getCryptography(), msgId, validated});
        return validated;
    }

    protected abstract Set<EValidationType> doValidate(MimeMessage var1) throws Exception;

    @Override
    public T extractPublicKey(MimeMessage msg) {
        T key;
        if (msg == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Optional<String> email = MessageUtil.getFromEmail(msg);
        if (!email.isPresent()) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        Logger log = this.getLog();
        String msgId = MessageUtil.getMessageId((Message)msg);
        log.info("Extracing public key from message for {} with msg ID: {}", (Object)this.getCryptography(), (Object)msgId);
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            try {
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Email:\n{}\n", (Object)debugBaos.toString());
            }
            catch (Exception e) {
                log.error("Could not log message. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        try {
            key = this.doExtract(msg, email.get());
        }
        catch (Exception e) {
            log.error("Could not extract public key from message with msg ID " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            key = this.getValidityKey(EKeyValidity.ERROR);
        }
        if (key == null) {
            key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("Finished extracing public key from message for {} with msg ID {}. Extracted key: {}", new Object[]{this.getCryptography(), msgId, key});
        return key;
    }

    protected abstract T doExtract(MimeMessage var1, String var2) throws Exception;
}

