/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor;

import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.cryptography.mail.visitor.IMessageVisitor;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeMessageVisitor
implements IMessageVisitor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private String msgId;

    public void visit(MimeMessage msg) throws Exception {
        this.reset();
        this.msgId = MessageUtil.getMessageId((Message)msg);
        this.getLog().trace("Starting visiting message: {}", (Object)this.msgId);
        this.visit((MimePart)msg);
        this.getLog().trace("Finished visiting message: {}", (Object)this.msgId);
    }

    @Override
    public void visit(MimeMultipart multi) throws Exception {
        int count = multi.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart part = multi.getBodyPart(i);
            if (!(part instanceof MimeBodyPart)) continue;
            this.visit((MimePart)((MimeBodyPart)part));
        }
    }

    @Override
    public void visit(MimePart part) throws Exception {
        Object content = part.getContent();
        if (content instanceof MimeMultipart) {
            this.visit((MimeMultipart)content);
        }
    }

    protected void reset() {
        this.msgId = null;
    }

    protected String getMsgId() {
        return this.msgId;
    }

    protected Logger getLog() {
        return this.log;
    }
}

