/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeDecryptionKeyStoreLoader;
import net.savignano.cryptography.key.smime.SmimeDecryptionKey;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.APrivateKeyManager;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeDecryptionKeyManager
extends APrivateKeyManager<SmimeDecryptionKey, KeyTransRecipientId> {
    private static final Logger log = LoggerFactory.getLogger(SmimeDecryptionKeyManager.class);

    public SmimeDecryptionKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeDecryptionKey, KeyTransRecipientId>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeDecryptionKey, KeyTransRecipientId>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeDecryptionKey, KeyTransRecipientId>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SmimeDecryptionKey, KeyTransRecipientId>> createKeyStoreLoader() {
        KeyStore ks;
        String location = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No S/MIME key store configured to retrieve S/MIME private keys from.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_SMIME_KEY_PASSWORD)) {
            log.error("Error retrieving password for S/MIME private key.");
            return Optional.empty();
        }
        log.debug("Loading S/MIME key store from location: {}", (Object)location);
        try {
            ks = KeyStore.getInstance("PKCS12", SecurityUtil.getProvider());
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, keyPassword);
            }
            log.debug("Loaded S/MIME key store from location \"{}\" succesfully.", (Object)location);
        }
        catch (Exception e) {
            log.error("Could not load S/MIME key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new SmimeDecryptionKeyStoreLoader(ks, keyPassword));
    }

    @Override
    protected SmimeDecryptionKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SmimeDecryptionKey(validity, keySource);
    }

    @Override
    protected Class<SmimeDecryptionKey> getCacheClass() {
        return SmimeDecryptionKey.class;
    }
}

