/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer;

import java.util.List;
import java.util.regex.Pattern;
import javax.mail.Message;
import javax.mail.internet.MimeMessage;
import net.savignano.cryptography.mail.visitor.RegexVisitor;
import net.savignano.cryptography.util.MessageUtil;
import org.slf4j.LoggerFactory;

public class IgnoreEncryptionDetector {
    private final RegexVisitor positiveVisitor;
    private final RegexVisitor negativeVisitor;

    private static final Pattern createPositivePattern(String baseUrl) {
        StringBuilder builder = new StringBuilder(baseUrl.length() + 100);
        builder.append("\\Qhref=\"");
        builder.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            builder.append('/');
        }
        builder.append("\\E(?:");
        builder.append("\\Qresetuserpassword.action?username=\\E\\w+\\Q&amp;token=\\E[0-9a-f]{40}");
        builder.append('|');
        builder.append("\\Qsignup.action?token=\\E[0-9a-f]{16}");
        builder.append(")\\\"");
        return Pattern.compile(builder.toString());
    }

    private static final Pattern createNegativePattern(String baseUrl) {
        StringBuilder builder = new StringBuilder(1024);
        builder.append("\\Qhref=\"");
        builder.append(baseUrl);
        if (!baseUrl.endsWith("/")) {
            builder.append('/');
        }
        builder.append("\\E(?:");
        builder.append("\\Qdisplay/\\E[^~\"][^\"]*+");
        builder.append('|');
        builder.append("\\Qpages/viewpage.action?\\E[^\"]*+");
        builder.append('|');
        builder.append("\\Qpages/viewpreviousversions.action?\\E[^\"]*+");
        builder.append('|');
        builder.append("\\Qplugins/likes/like.action?\\E[^\"]*+");
        builder.append(")\\\"");
        return Pattern.compile(builder.toString());
    }

    public IgnoreEncryptionDetector(String baseUrl) {
        if (baseUrl == null) {
            throw new IllegalArgumentException("Base URL must not be null.");
        }
        this.positiveVisitor = new RegexVisitor(IgnoreEncryptionDetector.createPositivePattern(baseUrl));
        this.positiveVisitor.setContentType("text/html");
        this.negativeVisitor = new RegexVisitor(IgnoreEncryptionDetector.createNegativePattern(baseUrl));
        this.negativeVisitor.setContentType("text/html");
    }

    public boolean isIgnoreEncryptionEmail(MimeMessage msg) {
        try {
            this.positiveVisitor.visit(msg);
            if (!((List)this.positiveVisitor.getResult()).isEmpty()) {
                this.negativeVisitor.visit(msg);
                return ((List)this.negativeVisitor.getResult()).isEmpty();
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger(this.getClass()).error("Could not check if message with ID \"" + MessageUtil.getMessageId((Message)msg) + "\" is an account relevant email. Error message: " + e.getMessage(), (Throwable)e);
        }
        return false;
    }
}

