/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.path;

import java.util.HashSet;
import java.util.Set;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.util.Memoable;

public class CertPathValidationContext
implements Memoable {
    private Set criticalExtensions;
    private Set handledExtensions = new HashSet();
    private boolean endEntity;
    private int index;

    public CertPathValidationContext(Set criticalExtensionsOIDs) {
        this.criticalExtensions = criticalExtensionsOIDs;
    }

    public void addHandledExtension(ASN1ObjectIdentifier extensionIdentifier) {
        this.handledExtensions.add(extensionIdentifier);
    }

    public void setIsEndEntity(boolean isEndEntity) {
        this.endEntity = isEndEntity;
    }

    public Set getUnhandledCriticalExtensionOIDs() {
        HashSet rv = new HashSet(this.criticalExtensions);
        rv.removeAll(this.handledExtensions);
        return rv;
    }

    public boolean isEndEntity() {
        return this.endEntity;
    }

    @Override
    public Memoable copy() {
        CertPathValidationContext c = new CertPathValidationContext(new HashSet(this.criticalExtensions));
        c.handledExtensions = new HashSet(this.handledExtensions);
        c.endEntity = this.endEntity;
        c.index = this.index;
        return c;
    }

    @Override
    public void reset(Memoable other) {
        CertPathValidationContext c = (CertPathValidationContext)other;
        this.criticalExtensions = new HashSet(c.criticalExtensions);
        this.handledExtensions = new HashSet(c.handledExtensions);
        this.endEntity = c.endEntity;
        this.index = c.index;
    }
}

