/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.digests;

import net.savignano.thirdparty.org.bouncycastle.crypto.ExtendedDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.Blake2bDigest;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class Blake2bpDigest
implements ExtendedDigest {
    private int bufferPos = 0;
    private int keyLength = 0;
    private int digestLength;
    private int fanout;
    private int depth;
    private int nodeOffset = 0;
    private long innerHashLength;
    private Blake2bDigest[] S = new Blake2bDigest[4];
    private Blake2bDigest root;
    private byte[] buffer = null;
    private byte[] salt = null;
    private byte[] param = null;
    private byte[] key = null;
    private final int BLAKE2B_BLOCKBYTES = 128;
    private final int BLAKE2B_KEYBYTES = 64;
    private final int BLAKE2B_OUTBYTES = 64;
    private final int PARALLELISM_DEGREE = 4;
    private final byte[] singleByte = new byte[1];

    public Blake2bpDigest(byte[] key) {
        this.param = new byte[64];
        this.buffer = new byte[512];
        this.init(key);
    }

    @Override
    public String getAlgorithmName() {
        return "BLAKE2bp";
    }

    @Override
    public int getDigestSize() {
        return this.digestLength;
    }

    @Override
    public void update(byte in) {
        this.singleByte[0] = in;
        this.update(this.singleByte, 0, 1);
    }

    @Override
    public void update(byte[] message, int offset, int len) {
        int i;
        int left = this.bufferPos;
        int remainingLength = 1024 - left;
        if (left != 0 && len >= remainingLength) {
            System.arraycopy(message, offset, this.buffer, left, remainingLength);
            for (i = 0; i < 4; ++i) {
                this.S[i].update(this.buffer, i * 128, 128);
            }
            offset += remainingLength;
            len -= remainingLength;
            left = 0;
        }
        for (i = 0; i < 4; ++i) {
            int inOffset = offset;
            inOffset += i * 128;
            for (int inlen = len; inlen >= 512; inlen -= 512) {
                this.S[i].update(message, inOffset, 128);
                inOffset += 512;
            }
        }
        offset += len - len % 512;
        if ((len %= 512) > 0) {
            System.arraycopy(message, offset, this.buffer, left, len);
        }
        this.bufferPos = left + len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        int i;
        byte[][] hash = new byte[4][64];
        int remainingLength = 0;
        for (i = 0; i < 4; ++i) {
            if (this.bufferPos > i * 128) {
                remainingLength = this.bufferPos - i * 128;
                if (remainingLength > 128) {
                    remainingLength = 128;
                }
                this.S[i].update(this.buffer, i * 128, remainingLength);
            }
            this.S[i].doFinal(hash[i], 0);
        }
        for (i = 0; i < 4; ++i) {
            this.root.update(hash[i], 0, 64);
        }
        int length = this.root.doFinal(out, outOff);
        this.reset();
        return length;
    }

    @Override
    public void reset() {
        this.bufferPos = 0;
        this.digestLength = 64;
        this.root.reset();
        for (int i = 0; i < 4; ++i) {
            this.S[i].reset();
        }
        this.root.setAsLastNode();
        this.S[3].setAsLastNode();
        if (this.key != null) {
            byte[] block = new byte[128];
            System.arraycopy(this.key, 0, block, 0, this.keyLength);
            for (int i = 0; i < 4; ++i) {
                this.S[i].update(block, 0, 128);
            }
        }
    }

    @Override
    public int getByteLength() {
        return 0;
    }

    private void init(byte[] key) {
        if (key != null && key.length > 0) {
            this.keyLength = key.length;
            if (this.keyLength > 64) {
                throw new IllegalArgumentException("Keys > 64 bytes are not supported");
            }
            this.key = Arrays.clone(key);
        }
        this.bufferPos = 0;
        this.digestLength = 64;
        this.fanout = 4;
        this.depth = 2;
        this.innerHashLength = 64L;
        this.param[0] = (byte)this.digestLength;
        this.param[1] = (byte)this.keyLength;
        this.param[2] = (byte)this.fanout;
        this.param[3] = (byte)this.depth;
        this.param[16] = 1;
        this.param[17] = (byte)this.innerHashLength;
        this.root = new Blake2bDigest(null, this.param);
        Pack.intToLittleEndian(this.nodeOffset, this.param, 8);
        this.param[16] = 0;
        for (int i = 0; i < 4; ++i) {
            Pack.intToLittleEndian(i, this.param, 8);
            this.S[i] = new Blake2bDigest(null, this.param);
        }
        this.root.setAsLastNode();
        this.S[3].setAsLastNode();
        if (key != null && this.keyLength > 0) {
            byte[] block = new byte[128];
            System.arraycopy(key, 0, block, 0, this.keyLength);
            for (int i = 0; i < 4; ++i) {
                this.S[i].update(block, 0, 128);
            }
        }
    }
}

