/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import net.savignano.thirdparty.org.bouncycastle.apache.bzip2.CBZip2InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.CompressedDataPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.CompressionAlgorithmTags;
import net.savignano.thirdparty.org.bouncycastle.bcpg.Packet;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.Util;

public class PGPCompressedData
implements CompressionAlgorithmTags {
    CompressedDataPacket data;

    public PGPCompressedData(byte[] encData) throws IOException {
        this(Util.createBCPGInputStream(new ByteArrayInputStream(encData), 8));
    }

    public PGPCompressedData(InputStream inStream) throws IOException {
        this(Util.createBCPGInputStream(inStream, 8));
    }

    public PGPCompressedData(BCPGInputStream pIn) throws IOException {
        Packet packet = pIn.readPacket();
        if (!(packet instanceof CompressedDataPacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        this.data = (CompressedDataPacket)packet;
    }

    public int getAlgorithm() {
        return this.data.getAlgorithm();
    }

    public InputStream getInputStream() {
        return this.data.getInputStream();
    }

    public InputStream getDataStream() throws PGPException {
        if (this.getAlgorithm() == 0) {
            return this.getInputStream();
        }
        if (this.getAlgorithm() == 1) {
            return new InflaterInputStream(this.getInputStream(), new Inflater(true)){
                private boolean eof;
                {
                    this.eof = false;
                }

                @Override
                protected void fill() throws IOException {
                    if (this.eof) {
                        throw new EOFException("Unexpected end of ZIP input stream");
                    }
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        this.buf[0] = 0;
                        this.len = 1;
                        this.eof = true;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                }
            };
        }
        if (this.getAlgorithm() == 2) {
            return new InflaterInputStream(this.getInputStream()){
                private boolean eof;
                {
                    this.eof = false;
                }

                @Override
                protected void fill() throws IOException {
                    if (this.eof) {
                        throw new EOFException("Unexpected end of ZIP input stream");
                    }
                    this.len = this.in.read(this.buf, 0, this.buf.length);
                    if (this.len == -1) {
                        this.buf[0] = 0;
                        this.len = 1;
                        this.eof = true;
                    }
                    this.inf.setInput(this.buf, 0, this.len);
                }
            };
        }
        if (this.getAlgorithm() == 3) {
            try {
                return new CBZip2InputStream(this.getInputStream());
            }
            catch (IOException e) {
                throw new PGPException("I/O problem with stream: " + e, e);
            }
        }
        throw new PGPException("can't recognise compression algorithm: " + this.getAlgorithm());
    }
}

