/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.bcpg.S2K;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyUtils;
import net.savignano.thirdparty.org.bouncycastle.crypto.BlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.BufferedBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.InvalidCipherTextException;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA256Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.modes.AEADBlockCipher;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AEADParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.HKDFParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        super(passPhrase, s2kDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase) {
        this(passPhrase, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, S2K.Argon2Params argon2Params) {
        super(passPhrase, argon2Params);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        super(passPhrase, s2kDigestCalculator, s2kCount);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] passPhrase, int s2kCount) {
        super(passPhrase, new SHA1PGPDigestCalculator(), s2kCount);
    }

    @Override
    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        super.setSecureRandom(random);
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(int encAlgorithm, byte[] key, byte[] sessionInfo) throws PGPException {
        try {
            BlockCipher engine = BcImplProvider.createBlockCipher(encAlgorithm);
            BufferedBlockCipher cipher = BcUtil.createSymmetricKeyWrapper(true, engine, key, new byte[engine.getBlockSize()]);
            byte[] out = new byte[sessionInfo.length];
            int len = cipher.processBytes(sessionInfo, 0, sessionInfo.length, out, 0);
            len += cipher.doFinal(out, len);
            return out;
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("encryption failed: " + e.getMessage(), e);
        }
    }

    @Override
    protected byte[] generateV6KEK(int kekAlgorithm, byte[] ikm, byte[] info) throws PGPException {
        HKDFBytesGenerator hkdf = new HKDFBytesGenerator(new SHA256Digest());
        hkdf.init(new HKDFParameters(ikm, null, info));
        int kekLen = SymmetricKeyUtils.getKeyLengthInOctets(kekAlgorithm);
        byte[] kek = new byte[kekLen];
        hkdf.generateBytes(kek, 0, kek.length);
        return kek;
    }

    @Override
    protected byte[] getEskAndTag(int kekAlgorithm, int aeadAlgorithm, byte[] sessionInfo, byte[] key, byte[] iv, byte[] info) throws PGPException {
        byte[] sessionKey = new byte[sessionInfo.length - 3];
        System.arraycopy(sessionInfo, 1, sessionKey, 0, sessionKey.length);
        AEADBlockCipher aeadCipher = BcAEADUtil.createAEADCipher(kekAlgorithm, aeadAlgorithm);
        aeadCipher.init(true, new AEADParameters(new KeyParameter(key), 128, iv, info));
        int outLen = aeadCipher.getOutputSize(sessionKey.length);
        byte[] eskAndTag = new byte[outLen];
        int len = aeadCipher.processBytes(sessionKey, 0, sessionKey.length, eskAndTag, 0);
        try {
            len += aeadCipher.doFinal(eskAndTag, len);
        }
        catch (InvalidCipherTextException e) {
            throw new PGPException("cannot encrypt session info", e);
        }
        return eskAndTag;
    }
}

