/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo;

import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHAKEDigest;
import net.savignano.thirdparty.org.bouncycastle.crypto.engines.AESEngine;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.KeyParameter;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

abstract class FrodoMatrixGenerator {
    int n;
    int q;

    public FrodoMatrixGenerator(int n, int q) {
        this.n = n;
        this.q = q;
    }

    abstract short[] genMatrix(byte[] var1);

    static class Aes128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Aes128MatrixGenerator(int n, int q) {
            super(n, q);
        }

        @Override
        short[] genMatrix(byte[] seedA) {
            short[] A = new short[this.n * this.n];
            byte[] b = new byte[16];
            byte[] c = new byte[16];
            AESEngine cipher = new AESEngine();
            cipher.init(true, new KeyParameter(seedA));
            for (int i = 0; i < this.n; ++i) {
                Pack.shortToLittleEndian((short)i, b, 0);
                for (int j = 0; j < this.n; j += 8) {
                    Pack.shortToLittleEndian((short)j, b, 2);
                    cipher.processBlock(b, 0, c, 0);
                    for (int k = 0; k < 8; ++k) {
                        A[i * this.n + j + k] = (short)(Pack.littleEndianToShort(c, 2 * k) & this.q - 1);
                    }
                }
            }
            return A;
        }
    }

    static class Shake128MatrixGenerator
    extends FrodoMatrixGenerator {
        public Shake128MatrixGenerator(int n, int q) {
            super(n, q);
        }

        @Override
        short[] genMatrix(byte[] seedA) {
            short[] A = new short[this.n * this.n];
            byte[] tmp = new byte[16 * this.n / 8];
            byte[] b = new byte[2 + seedA.length];
            System.arraycopy(seedA, 0, b, 2, seedA.length);
            SHAKEDigest digest = new SHAKEDigest(128);
            for (short i = 0; i < this.n; i = (short)(i + 1)) {
                Pack.shortToLittleEndian(i, b, 0);
                digest.update(b, 0, b.length);
                digest.doFinal(tmp, 0, tmp.length);
                for (int j = 0; j < this.n; j = (int)((short)(j + 1))) {
                    A[i * this.n + j] = (short)(Pack.littleEndianToShort(tmp, 2 * j) & this.q - 1);
                }
            }
            return A;
        }
    }
}

