/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms;

import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.DigestUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMOtsParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSContext;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LMSigParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.LmsUtils;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.lms.SeedDerive;

class LMOtsPrivateKey {
    private final LMOtsParameters parameter;
    private final byte[] I;
    private final int q;
    private final byte[] masterSecret;

    LMOtsPrivateKey(LMOtsParameters parameter, byte[] i, int q, byte[] masterSecret) {
        this.parameter = parameter;
        this.I = i;
        this.q = q;
        this.masterSecret = masterSecret;
    }

    LMSContext getSignatureContext(LMSigParameters sigParams, byte[][] path) {
        byte[] C = new byte[this.parameter.getN()];
        SeedDerive derive = this.getDerivationFunction();
        derive.setJ(-3);
        derive.deriveSeed(C, false);
        Digest ctx = DigestUtil.getDigest(this.parameter);
        LmsUtils.byteArray(this.getI(), ctx);
        LmsUtils.u32str(this.getQ(), ctx);
        LmsUtils.u16str((short)-32383, ctx);
        LmsUtils.byteArray(C, ctx);
        return new LMSContext(this, sigParams, ctx, C, path);
    }

    SeedDerive getDerivationFunction() {
        SeedDerive derive = new SeedDerive(this.I, this.masterSecret, DigestUtil.getDigest(this.parameter));
        derive.setQ(this.q);
        return derive;
    }

    public LMOtsParameters getParameter() {
        return this.parameter;
    }

    public byte[] getI() {
        return this.I;
    }

    public int getQ() {
        return this.q;
    }

    public byte[] getMasterSecret() {
        return this.masterSecret;
    }
}

