/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ExchangePair;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.ExchangePairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NHPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.newhope.NewHope;

public class NHExchangePairGenerator
implements ExchangePairGenerator {
    private final SecureRandom random;

    public NHExchangePairGenerator(SecureRandom random) {
        this.random = random;
    }

    public ExchangePair GenerateExchange(AsymmetricKeyParameter senderPublicKey) {
        return this.generateExchange(senderPublicKey);
    }

    @Override
    public ExchangePair generateExchange(AsymmetricKeyParameter senderPublicKey) {
        NHPublicKeyParameters pubKey = (NHPublicKeyParameters)senderPublicKey;
        byte[] sharedValue = new byte[32];
        byte[] publicKeyValue = new byte[2048];
        NewHope.sharedB(this.random, sharedValue, publicKeyValue, pubKey.pubData);
        return new ExchangePair(new NHPublicKeyParameters(publicKeyValue), sharedValue);
    }
}

