/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateBase;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.CertificateType;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.IssuerIdentifier;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.ToBeSignedCertificate;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.Signature;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.UINT8;

public class ImplicitCertificate
extends CertificateBase {
    public ImplicitCertificate(CertificateBase base) {
        this(base.getVersion(), base.getIssuer(), base.getToBeSigned(), base.getSignature());
    }

    public ImplicitCertificate(UINT8 version, IssuerIdentifier issuer, ToBeSignedCertificate toBeSignedCertificate, Signature signature) {
        super(version, CertificateType.implicit, issuer, toBeSignedCertificate, signature);
    }

    private ImplicitCertificate(ASN1Sequence sequence) {
        super(sequence);
        if (!this.getType().equals(CertificateType.implicit)) {
            throw new IllegalArgumentException("object was certificate base but the type was not implicit");
        }
    }

    public static ImplicitCertificate getInstance(Object o) {
        if (o instanceof ImplicitCertificate) {
            return (ImplicitCertificate)o;
        }
        if (o != null) {
            return new ImplicitCertificate(ASN1Sequence.getInstance(o));
        }
        return null;
    }
}

