/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pkcs;

import java.util.Enumeration;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSet;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.Attribute;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.CertificationRequest;
import net.savignano.thirdparty.org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.pkcs.DeltaCertificateRequestAttributeValue;
import net.savignano.thirdparty.org.bouncycastle.pkcs.PKCS10CertificationRequest;
import net.savignano.thirdparty.org.bouncycastle.pkcs.PKCSException;

public class DeltaCertAttributeUtils {
    public static boolean isDeltaRequestSignatureValid(PKCS10CertificationRequest baseRequest, ContentVerifierProvider contentVerifierProvider) throws PKCSException {
        Attribute[] attributes = baseRequest.getAttributes(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.2"));
        DeltaCertificateRequestAttributeValue deltaReq = new DeltaCertificateRequestAttributeValue(attributes[0]);
        attributes = baseRequest.getAttributes(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.3"));
        CertificationRequest deltaPkcs10 = baseRequest.toASN1Structure();
        CertificationRequestInfo deltaInfo = deltaPkcs10.getCertificationRequestInfo();
        ASN1EncodableVector deltaPkcs10InfoV = new ASN1EncodableVector();
        deltaPkcs10InfoV.add(deltaInfo.getVersion());
        deltaPkcs10InfoV.add(deltaInfo.getSubject());
        deltaPkcs10InfoV.add(deltaInfo.getSubjectPublicKeyInfo());
        ASN1EncodableVector attrSetV = new ASN1EncodableVector();
        Enumeration en = deltaInfo.getAttributes().getObjects();
        while (en.hasMoreElements()) {
            Attribute attr = Attribute.getInstance(en.nextElement());
            if (attr.getAttrType().equals(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.3"))) continue;
            attrSetV.add(attr);
        }
        deltaPkcs10InfoV.add(new DERTaggedObject(false, 0, (ASN1Encodable)new DERSet(attrSetV)));
        ASN1EncodableVector deltaPkcs10V = new ASN1EncodableVector();
        deltaPkcs10V.add(new DERSequence(deltaPkcs10InfoV));
        deltaPkcs10V.add(deltaReq.getSignatureAlgorithm());
        deltaPkcs10V.add(attributes[0].getAttributeValues()[0]);
        PKCS10CertificationRequest deltaPkcs10Req = new PKCS10CertificationRequest(CertificationRequest.getInstance(new DERSequence(deltaPkcs10V)));
        return deltaPkcs10Req.isSignatureValid(contentVerifierProvider);
    }
}

