/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.hqc;

class GF2PolynomialCalculator {
    private final int VEC_N_SIZE_64;
    private final int PARAM_N;
    private final long RED_MASK;

    GF2PolynomialCalculator(int vec_n_size_64, int param_n, long red_mask) {
        this.VEC_N_SIZE_64 = vec_n_size_64;
        this.PARAM_N = param_n;
        this.RED_MASK = red_mask;
    }

    protected void multLongs(long[] res, long[] a, long[] b) {
        long[] stack = new long[this.VEC_N_SIZE_64 << 3];
        long[] o_karat = new long[(this.VEC_N_SIZE_64 << 1) + 1];
        this.karatsuba(o_karat, 0, a, 0, b, 0, this.VEC_N_SIZE_64, stack, 0);
        this.reduce(res, o_karat);
    }

    private void base_mul(long[] c, int cOffset, long a, long b) {
        int i;
        long h = 0L;
        long l = 0L;
        long[] u = new long[16];
        long[] mask_tab = new long[4];
        u[0] = 0L;
        u[1] = b & 0xFFFFFFFFFFFFFFFL;
        u[2] = u[1] << 1;
        u[3] = u[2] ^ u[1];
        u[4] = u[2] << 1;
        u[5] = u[4] ^ u[1];
        u[6] = u[3] << 1;
        u[7] = u[6] ^ u[1];
        u[8] = u[4] << 1;
        u[9] = u[8] ^ u[1];
        u[10] = u[5] << 1;
        u[11] = u[10] ^ u[1];
        u[12] = u[6] << 1;
        u[13] = u[12] ^ u[1];
        u[14] = u[7] << 1;
        u[15] = u[14] ^ u[1];
        long g = 0L;
        long tmp1 = a & 0xFL;
        for (i = 0; i < 16; ++i) {
            long tmp2 = tmp1 - (long)i;
            g ^= u[i] & -(1L - ((tmp2 | -tmp2) >>> 63));
        }
        l = g;
        h = 0L;
        for (i = 4; i < 64; i = (int)((byte)(i + 4))) {
            g = 0L;
            long temp1 = a >> i & 0xFL;
            for (int j = 0; j < 16; ++j) {
                long tmp2 = temp1 - (long)j;
                g ^= u[j] & -(1L - ((tmp2 | -tmp2) >>> 63));
            }
            l ^= g << i;
            h ^= g >>> 64 - i;
        }
        mask_tab[0] = -(b >> 60 & 1L);
        mask_tab[1] = -(b >> 61 & 1L);
        mask_tab[2] = -(b >> 62 & 1L);
        mask_tab[3] = -(b >> 63 & 1L);
        l ^= a << 60 & mask_tab[0];
        h ^= a >>> 4 & mask_tab[0];
        l ^= a << 61 & mask_tab[1];
        h ^= a >>> 3 & mask_tab[1];
        l ^= a << 62 & mask_tab[2];
        h ^= a >>> 2 & mask_tab[2];
        c[0 + cOffset] = l ^= a << 63 & mask_tab[3];
        c[1 + cOffset] = h ^= a >>> 1 & mask_tab[3];
    }

    private void karatsuba_add1(long[] alh, int alhOffset, long[] blh, int blhOffset, long[] a, int aOffset, long[] b, int bOffset, int size_l, int size_h) {
        for (int i = 0; i < size_h; ++i) {
            alh[i + alhOffset] = a[i + aOffset] ^ a[i + size_l + aOffset];
            blh[i + blhOffset] = b[i + bOffset] ^ b[i + size_l + bOffset];
        }
        if (size_h < size_l) {
            alh[size_h + alhOffset] = a[size_h + aOffset];
            blh[size_h + blhOffset] = b[size_h + bOffset];
        }
    }

    private void karatsuba_add2(long[] o, int oOffset, long[] tmp1, int tmp1Offset, long[] tmp2, int tmp2Offset, int size_l, int size_h) {
        int i;
        for (i = 0; i < 2 * size_l; ++i) {
            tmp1[i + tmp1Offset] = tmp1[i + tmp1Offset] ^ o[i + oOffset];
        }
        for (i = 0; i < 2 * size_h; ++i) {
            tmp1[i + tmp1Offset] = tmp1[i + tmp1Offset] ^ tmp2[i + tmp2Offset];
        }
        for (i = 0; i < 2 * size_l; ++i) {
            o[i + size_l + oOffset] = o[i + size_l + oOffset] ^ tmp1[i + tmp1Offset];
        }
    }

    private void karatsuba(long[] o, int oOffset, long[] a, int aOffset, long[] b, int bOffset, int size, long[] stack, int stackOffset) {
        if (size == 1) {
            this.base_mul(o, oOffset, a[0 + aOffset], b[0 + bOffset]);
            return;
        }
        int size_h = size / 2;
        int size_l = (size + 1) / 2;
        int alhOffset = stackOffset;
        int blhOffset = alhOffset + size_l;
        int tmp1Offset = blhOffset + size_l;
        int tmp2Offset = oOffset + size_l * 2;
        int ahOffset = aOffset + size_l;
        int bhOffset = bOffset + size_l;
        this.karatsuba(o, oOffset, a, aOffset, b, bOffset, size_l, stack, stackOffset += 4 * size_l);
        this.karatsuba(o, tmp2Offset, a, ahOffset, b, bhOffset, size_h, stack, stackOffset);
        this.karatsuba_add1(stack, alhOffset, stack, blhOffset, a, aOffset, b, bOffset, size_l, size_h);
        this.karatsuba(stack, tmp1Offset, stack, alhOffset, stack, blhOffset, size_l, stack, stackOffset);
        this.karatsuba_add2(o, oOffset, stack, tmp1Offset, o, tmp2Offset, size_l, size_h);
    }

    private void reduce(long[] o, long[] a) {
        for (int i = 0; i < this.VEC_N_SIZE_64; ++i) {
            long r = a[i + this.VEC_N_SIZE_64 - 1] >>> (this.PARAM_N & 0x3F);
            long carry = a[i + this.VEC_N_SIZE_64] << (int)(64L - ((long)this.PARAM_N & 0x3FL));
            o[i] = a[i] ^ r ^ carry;
        }
        int n = this.VEC_N_SIZE_64 - 1;
        o[n] = o[n] & this.RED_MASK;
    }

    static void addLongs(long[] res, long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            res[i] = a[i] ^ b[i];
        }
    }
}

