/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xwing;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.agreement.X25519Agreement;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.SHA3Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.kyber.KyberKEMGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class XWingKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public XWingKEMGenerator(SecureRandom random) {
        this.sr = random;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        XWingPublicKeyParameters key = (XWingPublicKeyParameters)recipientKey;
        KyberKEMGenerator kybKem = new KyberKEMGenerator(this.sr);
        SecretWithEncapsulation kybSecWithEnc = kybKem.generateEncapsulated(key.getKyberPublicKey());
        X25519Agreement xdhAgree = new X25519Agreement();
        byte[] kybSecret = kybSecWithEnc.getSecret();
        byte[] k = new byte[kybSecret.length + xdhAgree.getAgreementSize()];
        System.arraycopy(kybSecret, 0, k, 0, kybSecret.length);
        Arrays.clear(kybSecret);
        X25519KeyPairGenerator xdhGen = new X25519KeyPairGenerator();
        xdhGen.init(new X25519KeyGenerationParameters(this.sr));
        AsymmetricCipherKeyPair ephXdh = xdhGen.generateKeyPair();
        xdhAgree.init(ephXdh.getPrivate());
        xdhAgree.calculateAgreement(key.getXDHPublicKey(), k, kybSecret.length);
        X25519PublicKeyParameters ephXdhPub = (X25519PublicKeyParameters)ephXdh.getPublic();
        SHA3Digest sha3 = new SHA3Digest(256);
        sha3.update(Strings.toByteArray("\\.//^\\"), 0, 6);
        sha3.update(k, 0, k.length);
        sha3.update(ephXdhPub.getEncoded(), 0, 32);
        sha3.update(key.getXDHPublicKey().getEncoded(), 0, 32);
        byte[] kemSecret = new byte[32];
        sha3.doFinal(kemSecret, 0);
        return new SecretWithEncapsulationImpl(kemSecret, Arrays.concatenate(kybSecWithEnc.getEncapsulation(), ephXdhPub.getEncoded()));
    }
}

