/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.AKeyLoader;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public abstract class ALdapLoader<T extends ICryptographyKey<?>>
extends AKeyLoader<T, Pair<String, String>> {
    public static final int INFO_NO_USER_FILTER = 200;
    public static final int INFO_LDAP_CONNECTED = 201;
    public static final int INFO_LDAP_DISCONNECTED = 202;
    public static final int INFO_LDAP_CONNECTION_ERROR = 203;
    public static final int INFO_USER_FOUND = 204;
    public static final int INFO_USER_NOT_FOUND = 205;
    private final LdapConnector connector;
    private EKeySource keySource = EKeySource.STANDARD_LDAP;
    private Map<String, String> environment;

    public ALdapLoader(LdapConnector connector) {
        this.connector = connector;
        if (connector == null) {
            throw new IllegalArgumentException("LDAP connector must not be null.");
        }
    }

    @Override
    public T loadKey(Pair<String, String> forId) {
        return super.loadKey(forId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T loadInternalKey(Pair<String, String> forId) throws Exception {
        Logger log = this.getLog();
        if (forId == null || forId.getLeft() == null) {
            log.warn("No user filter given to look up key for in LDAP.");
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        String userFilter = (String)forId.getLeft();
        String email = (String)forId.getRight();
        log.info("Looking up key for {} in LDAP.", (Object)userFilter);
        ICryptographyKey key = null;
        boolean connected = false;
        LdapConnector connector = this.getConnector();
        try {
            try {
                log.debug("Connecting to LDAP server: {}", (Object)connector.getUri());
                connector.connect(this.createEnvironment());
            }
            catch (Exception e) {
                log.error("Could not connect to ldap at " + connector.getHost() + " because of exception. Error message: " + e.getMessage(), (Throwable)e);
                this.getInfoDataManager().send(new InfoData(203, connector.getHost(), e));
                Object t = this.getValidityKey(EKeyValidity.ERROR);
                log.debug("Disconnecting from LDAP server.");
                if (connected) {
                    this.getInfoDataManager().send(new InfoData(202, connector.getHost()));
                }
                connector.disconnect();
                return t;
            }
        }
        catch (Throwable throwable) {
            log.debug("Disconnecting from LDAP server.");
            if (connected) {
                this.getInfoDataManager().send(new InfoData(202, connector.getHost()));
            }
            connector.disconnect();
            throw throwable;
        }
        connected = true;
        this.getInfoDataManager().send(new InfoData(201, connector.getHost()));
        try {
            key = (ICryptographyKey)this.loadLdapKey(userFilter, email);
        }
        catch (Exception e) {
            throw new Exception("Error retrieving key for " + userFilter + " in LDAP. Error message: " + e.getMessage(), e);
        }
        log.debug("Disconnecting from LDAP server.");
        if (connected) {
            this.getInfoDataManager().send(new InfoData(202, connector.getHost()));
        }
        connector.disconnect();
        if (key == null) {
            key = (ICryptographyKey)this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.info("S/MIME certificate for {} in LDAP is: {}", (Object)userFilter, (Object)key.getKeyValidity());
        return (T)key;
    }

    protected abstract T loadLdapKey(String var1, String var2) throws Exception;

    protected List<Attributes> getAttributes(DirContext context, String dn, String filter, String[] attrNames, String user) throws NamingException {
        Logger log = this.getLog();
        log.debug("Looking up information at dn '{}'. Used filter: {}", (Object)dn, (Object)filter);
        SearchControls searchControl = new SearchControls(2, 0L, 10000, attrNames, false, false);
        ArrayList<Attributes> attributes = new ArrayList<Attributes>();
        try {
            NamingEnumeration<SearchResult> results = context.search(dn != null ? dn : "", filter, searchControl);
            while (results.hasMore()) {
                SearchResult result = results.next();
                log.debug("Found user information at DN: {}", (Object)result.getNameInNamespace());
                attributes.add(result.getAttributes());
            }
        }
        catch (PartialResultException e) {
            if (this.ignoreReferral(context)) {
                log.info("Ignoring unprocessed continuation reference for dn '{}' with filter '{}'. Error message: ", new Object[]{dn, filter, e.getMessage()});
            }
            throw e;
        }
        if (attributes.isEmpty()) {
            log.info("Could not find user {} in LDAP. Search query: {} {}", new Object[]{user, dn, filter});
            this.getInfoDataManager().send(new InfoData(205, user));
        } else {
            this.getInfoDataManager().send(new InfoData(204, user));
        }
        return attributes;
    }

    private boolean ignoreReferral(Context context) {
        String referral;
        try {
            referral = (String)context.getEnvironment().get("java.naming.referral");
        }
        catch (NamingException e) {
            this.getLog().error(e.getMessage(), (Throwable)e);
            return false;
        }
        return "ignore".equalsIgnoreCase(referral);
    }

    protected Map<String, String> createEnvironment() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.getEnvironment() != null) {
            map.putAll(this.getEnvironment());
        }
        return map;
    }

    @Override
    public EKeySource getKeySource() {
        return this.keySource;
    }

    public void setKeySource(EKeySource keySource) {
        this.keySource = keySource != null ? keySource : EKeySource.STANDARD_LDAP;
    }

    public LdapConnector getConnector() {
        return this.connector;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Map<String, String> environment) {
        this.environment = environment;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [connector=" + this.getConnector() + ", environment=" + this.getEnvironment() + "]";
    }
}

