/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.ALdapLoader;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.slf4j.Logger;

public class PgpLdapLoader
extends ALdapLoader<PgpEncryptionKey> {
    private static final String PGP_KEY_ATTR = "pGPKey";

    public PgpLdapLoader(LdapConnector connector) {
        super(connector);
    }

    @Override
    protected PgpEncryptionKey loadLdapKey(String userFilter, String email) throws Exception {
        LdapConnector connector = this.getConnector();
        List<Attributes> attrs = this.getAttributes(connector.getContext(), connector.getDn(), connector.applyFilter(userFilter), new String[]{PGP_KEY_ATTR}, userFilter);
        PgpEncryptionKey key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        for (Attributes attributes : attrs) {
            PgpEncryptionKey otherKey = this.getKey(attributes.get(PGP_KEY_ATTR), userFilter, email);
            if (otherKey.compareTo(key) >= 0) continue;
            key = otherKey;
        }
        return key;
    }

    private PgpEncryptionKey getKey(Attribute attribute, String userFilter, String email) {
        String keyString;
        Logger log = this.getLog();
        if (attribute == null || attribute.size() == 0) {
            log.debug("No data stored in {} attribute.", (Object)PGP_KEY_ATTR);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Retrieving data from {} attribute.", (Object)PGP_KEY_ATTR);
        try {
            keyString = (String)attribute.get();
        }
        catch (NamingException e) {
            log.error("Could not read PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found PGP public key for {} in LDAP.", (Object)userFilter);
        try {
            PGPPublicKeyRing keyRing = PgpUtil.loadPublicKey(new ByteArrayInputStream(keyString.getBytes(Constants.UTF8_CHARSET)));
            PgpEncryptionKey key = new PgpEncryptionKey(keyRing, email);
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (IOException e) {
            log.error("Could not load PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpEncryptionKey getValidityKey(EKeyValidity validity) {
        return new PgpEncryptionKey(validity, this.getKeySource());
    }
}

