/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Collectors;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.pgp.PgpEncryptionKey;
import net.savignano.cryptography.mail.encrypt.AMailEncryptor;
import net.savignano.cryptography.mail.encrypt.PgpEncryptionResult;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;

public class PgpMailEncryptor
extends AMailEncryptor<PgpEncryptionKey, PgpEncryptionResult> {
    private int forceSymmetricKeyAlgorithm = -1;

    public PgpMailEncryptor(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    protected PgpEncryptionResult createResult(MimeMessage msg) {
        return new PgpEncryptionResult(msg);
    }

    @Override
    protected void encrypt(Collection<PgpEncryptionKey> keys, PgpEncryptionResult result) throws Exception {
        MimeMessage msg = result.getMessage();
        result.setSymmetricKeyAlgorithm(this.getSymmetricKeyAlgorithm(keys));
        byte[] encryptedBytes = this.encrypt(msg, this.toPgpKeys(keys), result.getSymmetricKeyAlgorithm());
        this.wrapIntoMessage(msg, encryptedBytes);
        this.includeEncryptionHeader(msg, PgpUtil.getSymmetricCipherName(result.getSymmetricKeyAlgorithm()));
    }

    protected int getSymmetricKeyAlgorithm(Collection<PgpEncryptionKey> keys) {
        Logger log = this.getLog();
        if (this.getForceSymmetricKeyAlgorithm() != -1) {
            log.debug("Forced symmetric key algorithm: {}", (Object)PgpUtil.getSymmetricCipherName(this.getForceSymmetricKeyAlgorithm()));
            return this.getForceSymmetricKeyAlgorithm();
        }
        ArrayList<Integer> sharedAlgorithms = new ArrayList<Integer>();
        boolean first = true;
        for (PgpEncryptionKey key : keys) {
            int[] algos = PgpUtil.getPreferredSymmetricKeyAlgorithms(key.getKeyRing());
            if (algos.length == 0) continue;
            if (first) {
                for (int i : algos) {
                    if (PgpUtil.isSupportedSymmetricKeyAlgorithm(i)) {
                        sharedAlgorithms.add(i);
                        continue;
                    }
                    log.warn("Symmetric key algorithm {} for key {} is not supported.", (Object)PgpUtil.getSymmetricCipherName(i), (Object)PgpUtil.getPrettyId(key.getKey()));
                }
                first = false;
            } else {
                Arrays.sort(algos);
                Iterator iter = sharedAlgorithms.iterator();
                while (iter.hasNext()) {
                    if (Arrays.binarySearch(algos, (Integer)iter.next()) >= 0) continue;
                    iter.remove();
                }
            }
            if (!sharedAlgorithms.isEmpty()) continue;
            break;
        }
        if (!sharedAlgorithms.isEmpty()) {
            int algo = (Integer)sharedAlgorithms.get(0);
            log.debug("Found shared algorithm: {} ({})", (Object)PgpUtil.getSymmetricCipherName(algo), (Object)algo);
            return algo;
        }
        log.info("No supported algorithm shared between recipient and sender key. Using fallback of AES 128.");
        return 7;
    }

    private byte[] encrypt(MimeMessage msg, PGPPublicKey[] encryptionKeys, int encryptionAlgorithm) throws IOException, MessagingException, PGPException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        byte[] encryptedBytes = PgpUtil.encrypt(baos.toByteArray(), encryptionKeys, encryptionAlgorithm, true, true);
        return encryptedBytes;
    }

    private PGPPublicKey[] toPgpKeys(Collection<PgpEncryptionKey> keys) {
        return keys.stream().map(PgpEncryptionKey::getKey).collect(Collectors.toList()).toArray(new PGPPublicKey[keys.size()]);
    }

    private void wrapIntoMessage(MimeMessage msg, byte[] encryptedBytes) throws IOException, MessagingException {
        MimeBodyPart partVersion = new MimeBodyPart();
        ByteArrayDataSource dsVersion = new ByteArrayDataSource("Version: 1\r\n", "application/pgp-encrypted");
        partVersion.setDataHandler(new DataHandler((DataSource)dsVersion));
        partVersion.setDescription("PGP/MIME version identification");
        MimeBodyPart partEncrypted = new MimeBodyPart();
        ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encryptedBytes, "application/octet-stream");
        partEncrypted.setDataHandler(new DataHandler((DataSource)dsEncrypted));
        partEncrypted.setDisposition("inline; filename=\"encrypted.asc\"");
        partEncrypted.setDescription("OpenPGP encrypted message");
        MimeMultipart multipart = new MimeMultipart("encrypted;\r\n\tprotocol=\"application/pgp-encrypted\"");
        multipart.addBodyPart((BodyPart)partVersion);
        multipart.addBodyPart((BodyPart)partEncrypted);
        msg.setContent((Multipart)multipart);
    }

    public int getForceSymmetricKeyAlgorithm() {
        return this.forceSymmetricKeyAlgorithm;
    }

    public void setForceSymmetricKeyAlgorithm(int forceSymmetricKeyAlgorithm) {
        this.forceSymmetricKeyAlgorithm = forceSymmetricKeyAlgorithm;
    }
}

