/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.version;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.savignano.cryptography.version.IVersion;

public class NormalizedVersion
implements IVersion,
Comparable<NormalizedVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\bv?(?<major>[0-9]+)(\\.(?<minor>[0-9]+))?+(\\.(?<patch>[0-9]+))?+\\b");
    private final int major;
    private final int minor;
    private final int patch;

    public NormalizedVersion(int major) {
        this(major, -1, -1);
    }

    public NormalizedVersion(int major, int minor) {
        this(major, minor, -1);
    }

    public NormalizedVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public NormalizedVersion(IVersion version) {
        this(version == null ? null : version.getVersion());
    }

    public NormalizedVersion(String version) {
        if (version == null) {
            this.major = -1;
            this.minor = -1;
            this.patch = -1;
            return;
        }
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.find()) {
            String majorGroup = matcher.group("major");
            this.major = Integer.parseInt(majorGroup);
            String minorGroup = matcher.group("minor");
            this.minor = minorGroup != null ? Integer.parseInt(minorGroup) : -1;
            String patchGroup = matcher.group("patch");
            this.patch = patchGroup != null ? Integer.parseInt(patchGroup) : -1;
            return;
        }
        this.major = -1;
        this.minor = -1;
        this.patch = -1;
    }

    @Override
    public String getVersion() {
        StringBuilder builder = new StringBuilder();
        if (this.getMajor() < 0) {
            builder.append("<N/A>");
        } else {
            builder.append(this.getMajor());
            if (this.getMinor() >= 0) {
                builder.append('.');
                builder.append(this.getMinor());
            }
            if (this.getPatch() >= 0) {
                builder.append('.');
                builder.append(this.getPatch());
            }
        }
        return builder.toString();
    }

    public boolean isLowerThan(NormalizedVersion version) {
        if (this.getMajor() < version.getMajor()) {
            return true;
        }
        if (this.getMajor() == version.getMajor()) {
            if (this.getMinor() < version.getMinor()) {
                return true;
            }
            if (this.getMinor() == version.getMinor() && this.getPatch() < version.getPatch()) {
                return true;
            }
        }
        return false;
    }

    public boolean isGreaterThan(NormalizedVersion version) {
        if (this.getMajor() > version.getMajor()) {
            return true;
        }
        if (this.getMajor() == version.getMajor()) {
            if (this.getMinor() > version.getMinor()) {
                return true;
            }
            if (this.getMinor() == version.getMinor() && this.getPatch() > version.getPatch()) {
                return true;
            }
        }
        return false;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.getVersion();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NormalizedVersion other = (NormalizedVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    @Override
    public int compareTo(NormalizedVersion o) {
        if (this.isLowerThan(o)) {
            return -1;
        }
        if (this.isGreaterThan(o)) {
            return 1;
        }
        return 0;
    }
}

