/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.pgp;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.pgp.PgpValidationKeyStoreLoader;
import net.savignano.cryptography.key.pgp.PgpValidationKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpValidationKeyManager
extends AKeyManager<PgpValidationKey, Long> {
    private static final Logger log = LoggerFactory.getLogger(PgpValidationKeyManager.class);
    private static final Map<Long, PgpValidationKey> keyCache = new HashMap<Long, PgpValidationKey>();
    private static final Map<Long, Instant> timeCache = new HashMap<Long, Instant>();

    public PgpValidationKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
    }

    @Override
    protected PgpValidationKey getCachedKey(Long forId) {
        return keyCache.getOrDefault(forId, this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
    }

    @Override
    protected void setCachedKey(Long forId, PgpValidationKey key) throws IOException {
        if (key != null) {
            keyCache.put(forId, key);
        } else {
            keyCache.remove(forId);
        }
        timeCache.put(forId, Instant.now());
    }

    @Override
    protected boolean isCacheAutomaticallyExpired(Long forId) {
        if (super.isCacheAutomaticallyExpired(forId)) {
            return true;
        }
        Instant cachedTimeStamp = this.getCachedTimeStamp(forId);
        if (cachedTimeStamp == null) {
            log.debug("Cache automatically expired: No cached key.");
            return true;
        }
        if (Instant.now().minus(1L, ChronoUnit.DAYS).isAfter(cachedTimeStamp)) {
            log.debug("Cache automatically expired: One day passed.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired(Long forId) {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired(forId)) {
            return true;
        }
        Instant cachedTimeStamp = this.getCachedTimeStamp(forId);
        if (cachedTimeStamp != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > cachedTimeStamp.toEpochMilli()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpValidationKey, Long>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpValidationKey, Long>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<PgpValidationKey, Long>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        return loaders;
    }

    private Optional<IKeyLoader<PgpValidationKey, Long>> createKeyStoreLoader() {
        PGPPublicKeyRingCollection keyRings;
        ISnotifyAppProperties appProps = this.getAppProps();
        String location = appProps.getString(EProperty.PUBLIC_KEYSTORE_PGP_LOCATION);
        if (location == null) {
            log.debug("No PGP key store configured to retrieve PGP public keys from.");
            return Optional.empty();
        }
        String keyStoreType = appProps.getString(EProperty.PUBLIC_KEYSTORE_PGP_TYPE);
        if (!keyStoreType.equals("KEYRING")) {
            log.debug("Cannot load validation keys from a non-keyring type key store.");
            return Optional.empty();
        }
        log.debug("PGP key store configured: {}", (Object)location);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
            keyRings = PgpUtil.loadPublicKeys(in);
        }
        catch (Exception e) {
            log.error("Could not load PGP key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        return Optional.of(new PgpValidationKeyStoreLoader(keyRings));
    }

    @Override
    protected PgpValidationKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new PgpValidationKey(validity, keySource);
    }

    protected Instant getCachedTimeStamp(Long id) {
        return timeCache.get(id);
    }

    protected void setCachedTimeStamp(Long id, Instant cachedTimeStamp) {
        timeCache.put(id, cachedTimeStamp);
    }
}

