/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.IKeyLoader;
import net.savignano.cryptography.key.loader.smime.SmimeSignKeyStoreLoader;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.mailer.keysource.APrivateKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeSignKeyManager
extends APrivateKeyManager<SmimeSignKey, String> {
    private static final Logger log = LoggerFactory.getLogger(SmimeSignKeyManager.class);

    public SmimeSignKeyManager(ISnotifyAppProperties appProps) {
        super(appProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeSignKey, String>>>>> getKeyLoaders() {
        ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeSignKey, String>>>>> loaders = new ArrayList<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SmimeSignKey, String>>>>>();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.KEYSTORE, this::createKeyStoreLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SmimeSignKey, String>> createKeyStoreLoader() {
        String location = this.getAppProps().getString(EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION);
        if (location == null) {
            log.debug("No private key store specified. Can't get decryption from key store.");
            return Optional.empty();
        }
        char[] keyPassword = this.getAppProps().getPassword(EProperty.PRIVATE_SMIME_KEY_PASSWORD);
        if (keyPassword == null && this.getAppProps().hasKey(EProperty.PRIVATE_SMIME_KEY_PASSWORD)) {
            log.error("Error retrieving password for S/MIME private key.");
            return Optional.empty();
        }
        try {
            KeyStore ks = KeyStore.getInstance("PKCS12", SecurityUtil.getProvider());
            log.debug("Loading key store from location: {}", (Object)location);
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(location));){
                ks.load(in, keyPassword);
            }
            SecurityUtil.clearPassword(keyPassword);
            log.debug("Loaded key store from location \"{}\" succesfully.", (Object)location);
            SmimeSignKeyStoreLoader loader = new SmimeSignKeyStoreLoader(ks, null);
            loader.setIgnoreCriticalExtension(!this.getAppProps().getBoolean(EProperty.TWEAK_SMIME_STRICT_CERTIFICATE_CHECKING));
            return Optional.of(loader);
        }
        catch (Exception e) {
            log.error("Could not load key store from location \"" + location + "\". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    protected SmimeSignKey getValidityKey(EKeyValidity validity, EKeySource keySource) {
        return new SmimeSignKey(validity, keySource);
    }

    @Override
    protected Class<SmimeSignKey> getCacheClass() {
        return SmimeSignKey.class;
    }
}

