/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.extractor;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import net.savignano.snotify.confluence.mailer.extractor.APermissionAwareMailKeyExtractor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailPageIdExtractor
extends APermissionAwareMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailPageIdExtractor.class);

    public ConfluenceMailPageIdExtractor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getKey(URL url) {
        return this.getKeyDisplayVersion(url);
    }

    private String getKeyDisplayVersion(URL url) {
        String path = url.getPath();
        String indicator = "/display/";
        return this.getKey(path, "/display/");
    }

    private String getKey(String path, String indicator) {
        String pageTitle;
        String spaceId;
        int start;
        int end;
        int index = path.indexOf(indicator);
        if (index != -1 && (end = path.indexOf("/", start = index + indicator.length())) != -1 && !(spaceId = path.substring(start, end)).isEmpty() && spaceId.charAt(0) != '~' && !StringUtils.isEmpty((CharSequence)(pageTitle = path.substring(end + 1)))) {
            try {
                pageTitle = URLDecoder.decode(pageTitle, StandardCharsets.ISO_8859_1.name());
            }
            catch (UnsupportedEncodingException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            Optional<Content> optional = this.getContent(pageTitle);
            if (optional.isPresent()) {
                log.debug("Page with title {} has ID: {}", (Object)pageTitle, (Object)optional.get());
                return String.valueOf(optional.get().getId().asLong());
            }
            log.debug("Page with title {} not found.", (Object)pageTitle);
        }
        return null;
    }

    private Optional<Content> getContent(String pageTitle) {
        return this.getContentService().get(service -> service.find(new Expansion[0]).withType(new ContentType[]{ContentType.PAGE}).withTitle(pageTitle).fetch());
    }
}

