/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.mailer.extractor;

import com.atlassian.confluence.api.model.Expansion;
import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.api.model.content.ContentType;
import com.atlassian.confluence.api.model.content.id.ContentId;
import com.google.common.base.Strings;
import java.net.URL;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import net.savignano.snotify.confluence.mailer.extractor.APermissionAwareMailKeyExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceMailSpaceExtractor
extends APermissionAwareMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceMailSpaceExtractor.class);

    public ConfluenceMailSpaceExtractor(String baseUrl) {
        super(baseUrl);
    }

    @Override
    protected String getKey(URL url) {
        String key = this.getKeySpacesVersion(url);
        if (key == null) {
            key = this.getKeyDisplayVersion(url);
        }
        if (key == null) {
            key = this.getKeyQueryVersion(url);
        }
        return key;
    }

    private String getKeySpacesVersion(URL url) {
        String path = url.getPath();
        String indicator = "/spaces/";
        return this.getKeyNewVersion(path, "/spaces/");
    }

    private String getKeyDisplayVersion(URL url) {
        String path = url.getPath();
        String indicator = "/display/";
        return this.getKeyNewVersion(path, "/display/");
    }

    private String getKeyNewVersion(String path, String indicator) {
        String key;
        int start;
        int end;
        int index = path.indexOf(indicator);
        if (index != -1 && (end = path.indexOf("/", start = index + indicator.length())) != -1 && !(key = path.substring(start, end)).isEmpty() && key.charAt(0) != '~') {
            return key;
        }
        return null;
    }

    private String getKeyQueryVersion(URL url) {
        String key = null;
        String query = url.getQuery();
        if (!Strings.isNullOrEmpty((String)query) && (key = this.getViaSpaceKey(query)) == null) {
            key = this.getViaPageId(query);
        }
        return key;
    }

    private String getViaSpaceKey(String query) {
        Optional keyStr = Arrays.stream(query.split("&")).map(s -> s.split("=")).filter(a -> a[0].equals("spaceKey")).flatMap(a -> ((String[])a).length == 2 ? Stream.of(a[1]) : Stream.empty()).findAny();
        if (keyStr.isPresent()) {
            return (String)keyStr.get();
        }
        return null;
    }

    private String getViaPageId(String query) {
        Optional idStr = Arrays.stream(query.split("&")).map(s -> s.split("=")).filter(a -> a[0].equals("pageId")).flatMap(a -> ((String[])a).length == 2 ? Stream.of(a[1]) : Stream.empty()).findAny();
        if (idStr.isPresent()) {
            long id;
            try {
                id = Long.parseLong((String)idStr.get());
            }
            catch (NumberFormatException e) {
                log.debug("ID " + (String)idStr.get() + " is not an ID for a page.", (Throwable)e);
                return null;
            }
            return this.getSpaceKey(id);
        }
        return null;
    }

    private String getSpaceKey(long pageId) {
        Expansion spaceExpansion = new Expansion("space");
        Optional optional = this.getContentService().get(service -> service.find(new Expansion[]{spaceExpansion}).withType(new ContentType[]{ContentType.PAGE}).withId(ContentId.of((long)pageId), new ContentId[0]).fetch());
        if (optional.isPresent()) {
            log.debug("Page with ID {} belongs to space: {}", (Object)pageId, (Object)((Content)optional.get()).getSpace().getKey());
            return ((Content)optional.get()).getSpace().getKey();
        }
        log.debug("ID {} does not belong to a page.", (Object)pageId);
        return null;
    }
}

