/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.tsp;

import java.util.Enumeration;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class PartialHashtree
extends ASN1Object {
    private final ASN1Sequence values;

    public static PartialHashtree getInstance(Object obj) {
        if (obj instanceof PartialHashtree) {
            return (PartialHashtree)obj;
        }
        if (obj != null) {
            return new PartialHashtree(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PartialHashtree(ASN1Sequence values) {
        for (int i = 0; i != values.size(); ++i) {
            if (values.getObjectAt(i) instanceof ASN1OctetString) continue;
            throw new IllegalArgumentException("unknown object in constructor: " + values.getObjectAt(i).getClass().getName());
        }
        this.values = values;
    }

    public PartialHashtree(byte[] values) {
        this(new byte[][]{values});
    }

    public PartialHashtree(byte[][] values) {
        ASN1EncodableVector v = new ASN1EncodableVector(values.length);
        for (int i = 0; i != values.length; ++i) {
            v.add(new DEROctetString(Arrays.clone(values[i])));
        }
        this.values = new DERSequence(v);
    }

    public int getValueCount() {
        return this.values.size();
    }

    public byte[][] getValues() {
        byte[][] rv = new byte[this.values.size()][];
        for (int i = 0; i != rv.length; ++i) {
            rv[i] = Arrays.clone(ASN1OctetString.getInstance(this.values.getObjectAt(i)).getOctets());
        }
        return rv;
    }

    public boolean containsHash(byte[] hash) {
        Enumeration hashes = this.values.getObjects();
        while (hashes.hasMoreElements()) {
            byte[] currentHash = ASN1OctetString.getInstance(hashes.nextElement()).getOctets();
            if (!Arrays.constantTimeAreEqual(hash, currentHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.values;
    }
}

