/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo;

import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo.FrodoEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo.FrodoKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo.FrodoParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.frodo.FrodoPrivateKeyParameters;

public class FrodoKEMExtractor
implements EncapsulatedSecretExtractor {
    private FrodoEngine engine;
    private FrodoKeyParameters key;

    public FrodoKEMExtractor(FrodoKeyParameters privParams) {
        this.key = privParams;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(FrodoParameters param) {
        this.engine = param.getEngine();
    }

    @Override
    public byte[] extractSecret(byte[] encapsulation) {
        byte[] session_key = new byte[this.engine.getSessionKeySize()];
        this.engine.kem_dec(session_key, encapsulation, ((FrodoPrivateKeyParameters)this.key).getPrivateKey());
        return session_key;
    }

    @Override
    public int getEncapsulationLength() {
        return this.engine.getCipherTextSize();
    }
}

