/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key;

import java.util.Objects;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ICryptographyKey;

public abstract class ACryptographyKey<T>
implements ICryptographyKey<T>,
Comparable<ICryptographyKey<?>> {
    private final EKeyPurpose keyPurpose;
    private final ECryptographyType cryptography;
    private EKeyValidity keyValidity = EKeyValidity.VALID;
    private EKeySource keySource = EKeySource.UNKNOWN;

    protected ACryptographyKey(EKeyPurpose keyPurpose, ECryptographyType cryptography) {
        this.keyPurpose = keyPurpose == null ? EKeyPurpose.UNDEFINED : keyPurpose;
        this.cryptography = cryptography == null ? ECryptographyType.NONE : cryptography;
    }

    @Override
    public EKeyValidity getKeyValidity() {
        return this.keyValidity;
    }

    protected void setKeyValidity(EKeyValidity keyValidity) {
        this.keyValidity = keyValidity == null ? EKeyValidity.VALID : keyValidity;
    }

    @Override
    public EKeyPurpose getKeyPurpose() {
        return this.keyPurpose;
    }

    @Override
    public EKeySource getKeySource() {
        return this.keySource;
    }

    public void setKeySource(EKeySource keySource) {
        this.keySource = keySource == null ? EKeySource.UNKNOWN : keySource;
    }

    @Override
    public ECryptographyType getCryptography() {
        return this.cryptography;
    }

    @Override
    public int compareTo(ICryptographyKey<?> o) {
        if (o == null) {
            return -1;
        }
        return this.getKeyValidity().compareTo(o.getKeyValidity());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append(this.getClass().getSimpleName());
        builder.append(". ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Cryptography: ");
        builder.append((Object)this.getCryptography());
        builder.append("; Key: ");
        builder.append(this.getKey());
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cryptography, this.keyValidity, this.keyPurpose, this.keySource, this.getKey()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ACryptographyKey other = (ACryptographyKey)obj;
        return this.cryptography == other.cryptography && this.keyPurpose == other.keyPurpose && this.keySource == other.keySource && this.keyValidity == other.keyValidity && Objects.equals(this.getKey(), other.getKey());
    }
}

