/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.ALdapLoader;
import net.savignano.cryptography.key.loader.smime.SmimeCertificateP7bLoader;
import net.savignano.cryptography.key.smime.SmimeEncryptionKey;
import net.savignano.cryptography.util.SmimeUtil;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSSignedData;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import org.slf4j.Logger;

public class SmimeLdapLoader
extends ALdapLoader<SmimeEncryptionKey> {
    private static final String BINARY_TRANSFER = "java.naming.ldap.attributes.binary";
    private static final String USER_SMIME_CERT = "userSMIMECertificate";
    private static final String USER_CERT = "userCertificate";
    private boolean searchCert = true;
    private boolean searchSmime = true;
    private boolean expectP7b;
    private boolean ignoreCriticalExtension;

    public SmimeLdapLoader(LdapConnector connector) {
        super(connector);
    }

    @Override
    protected SmimeEncryptionKey loadLdapKey(String userFilter, String email) throws Exception {
        LdapConnector connector = this.getConnector();
        List<Attributes> attrs = this.getAttributes(connector.getContext(), connector.getDn(), connector.applyFilter(userFilter), this.getFieldParameter(), userFilter);
        if (!attrs.isEmpty()) {
            Attribute userSmimeCertAttr = null;
            Attribute userCertAttr = null;
            for (Attributes attributes : attrs) {
                NamingEnumeration<String> ids = attributes.getIDs();
                while (ids.hasMoreElements()) {
                    String id = (String)ids.nextElement();
                    this.getLog().trace("Attribute ID: {}", (Object)id);
                    if (id.startsWith(USER_CERT)) {
                        userCertAttr = attributes.get(id);
                        continue;
                    }
                    if (!id.startsWith(USER_SMIME_CERT)) continue;
                    userSmimeCertAttr = attributes.get(id);
                }
            }
            return this.getPublicKey(userSmimeCertAttr, userCertAttr, userFilter, email);
        }
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    @Override
    protected Map<String, String> createEnvironment() {
        Map<String, String> env = super.createEnvironment();
        env.put(BINARY_TRANSFER, USER_CERT);
        env.put(BINARY_TRANSFER, USER_SMIME_CERT);
        return env;
    }

    private SmimeEncryptionKey getPublicKey(Attribute userSmimeCertAttr, Attribute userCertAttr, String userFilter, String email) throws NamingException {
        SmimeEncryptionKey otherKey;
        SmimeEncryptionKey key = this.getValidityKey(EKeyValidity.NOT_FOUND);
        if (this.isSearchSmime()) {
            key = this.getKeyFromUserSmimeCert(userSmimeCertAttr, userFilter, email);
        }
        if (this.isSearchCert() && key.getKeyValidity() != EKeyValidity.VALID && (otherKey = this.getKeyFromUserCert(userCertAttr, userFilter, email)).compareTo(key) < 0) {
            key = otherKey;
        }
        return key;
    }

    private String[] getFieldParameter() {
        String[] stringArray;
        this.getLog().debug("Querying field {}: {}", (Object)USER_CERT, (Object)this.isSearchCert());
        this.getLog().debug("Querying field {}: {}", (Object)USER_SMIME_CERT, (Object)this.isSearchSmime());
        if (this.isSearchCert()) {
            String[] stringArray2;
            if (this.isSearchSmime()) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = USER_CERT;
                stringArray2 = stringArray3;
                stringArray3[1] = USER_SMIME_CERT;
            } else {
                String[] stringArray4 = new String[1];
                stringArray2 = stringArray4;
                stringArray4[0] = USER_CERT;
            }
            return stringArray2;
        }
        if (this.isSearchSmime()) {
            String[] stringArray5 = new String[1];
            stringArray = stringArray5;
            stringArray5[0] = USER_SMIME_CERT;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    private SmimeEncryptionKey getKeyFromUserSmimeCert(Attribute attribute, String userFilter, String email) throws NamingException {
        CMSSignedData signature;
        Logger log = this.getLog();
        if (attribute == null || attribute.get() == null) {
            log.debug("No data stored in {} attribute.", (Object)USER_SMIME_CERT);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Retrieving data from {} attribute.", (Object)USER_SMIME_CERT);
        byte[] bytes = this.asBytes(attribute.get());
        if (bytes == null) {
            log.warn("Wrong data format in {} attribute for user {} in LDAP. Expected String or bytes, but found: {}", (Object[])new String[]{USER_SMIME_CERT, userFilter, attribute.get().getClass().getName()});
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.debug("Loading p7 key store.");
        try (InputStream is = this.createP7InputStream(bytes);){
            signature = new CMSSignedData(is);
        }
        catch (CMSException e) {
            log.warn("Error loading S/MIME certificate for " + userFilter + " in LDAP. It appears that the content is not a properly formatted p7 certificate or certificate chain. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        catch (MessagingException | IOException e) {
            log.warn("Error loading S/MIME certificate for " + userFilter + " in LDAP. It appears that the stored content is not a properly formatted MIME message. Error message: " + e.getMessage(), e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.debug("Email address to look for: <{}>", (Object)email);
        Store<X509CertificateHolder> certStore = signature.getCertificates();
        SmimeCertificateP7bLoader loader = new SmimeCertificateP7bLoader(certStore);
        loader.setIgnoreCriticalExtension(this.isIgnoreCriticalExtension());
        SmimeEncryptionKey key = (SmimeEncryptionKey)loader.loadKey(email);
        key.setKeySource(this.getKeySource());
        return key;
    }

    private InputStream createP7InputStream(byte[] bytes) throws IOException, MessagingException {
        InputStream is;
        if (this.isExpectP7b()) {
            this.getLog().debug("Expecting p7b format.");
            is = new ByteArrayInputStream(bytes);
        } else {
            this.getLog().debug("Expecting p7m format.");
            MimeMessage msg = new MimeMessage(null, (InputStream)new ByteArrayInputStream(bytes));
            is = msg.getInputStream();
        }
        return is;
    }

    private SmimeEncryptionKey getKeyFromUserCert(Attribute attribute, String userFilter, String email) throws NamingException {
        Logger log = this.getLog();
        if (attribute == null || attribute.size() == 0) {
            log.debug("No data stored in {} attribute.", (Object)USER_CERT);
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        log.debug("Retrieving data from {} attribute.", (Object)attribute.getID());
        byte[] bytes = this.asBytes(attribute.get());
        if (bytes == null) {
            log.warn("Wrong data format in {} attribute for user {} in LDAP. Expected String or bytes, but found: {}", (Object[])new String[]{USER_CERT, userFilter, attribute.get().getClass().getName()});
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        log.info("Found S/MIME certificate for {} in LDAP.", (Object)userFilter);
        try {
            X509Certificate cert = SmimeUtil.createCertificate(bytes);
            log.trace("Found certificate: {}", (Object)cert);
            SmimeEncryptionKey key = new SmimeEncryptionKey(cert, email);
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (CertificateException e) {
            log.warn("Error loading S/MIME certificate for " + userFilter + " in LDAP. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    private byte[] asBytes(Object obj) {
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        if (obj instanceof String) {
            return ((String)obj).getBytes(Constants.UTF8_CHARSET);
        }
        return null;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SmimeEncryptionKey getValidityKey(EKeyValidity validity) {
        return new SmimeEncryptionKey(validity, this.getKeySource());
    }

    public boolean isSearchCert() {
        return this.searchCert;
    }

    public void setSearchCert(boolean searchCert) {
        this.searchCert = searchCert;
    }

    public boolean isSearchSmime() {
        return this.searchSmime;
    }

    public void setSearchSmime(boolean searchSmime) {
        this.searchSmime = searchSmime;
    }

    public boolean isExpectP7b() {
        return this.expectP7b;
    }

    public void setExpectP7b(boolean expectP7b) {
        this.expectP7b = expectP7b;
    }

    public boolean isIgnoreCriticalExtension() {
        return this.ignoreCriticalExtension;
    }

    public void setIgnoreCriticalExtension(boolean ignoreCriticalExtension) {
        this.ignoreCriticalExtension = ignoreCriticalExtension;
    }

    @Override
    public String toString() {
        return "SmimeLdapLoader [connector=" + this.getConnector() + ", searchCert=" + this.searchCert + ", searchSmime=" + this.searchSmime + ", expectP7b=" + this.expectP7b + "]";
    }
}

