/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.smime;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.security.auth.x500.X500Principal;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.smime.ASmimeKeyLoader;
import net.savignano.cryptography.key.smime.SmimeSignKey;
import net.savignano.cryptography.util.KeyStoreContentFetcher;
import net.savignano.cryptography.util.SmimeUtil;
import org.slf4j.Logger;

public class SmimeSignKeyStoreLoader
extends ASmimeKeyLoader<SmimeSignKey, String> {
    public static final int INFO_NO_KEY_STORE = 200;
    public static final int INFO_NO_EMAIL = 201;
    public static final int INFO_EMAIL_FOUND = 202;
    public static final int INFO_EMAIL_NOT_FOUND = 203;
    private final KeyStore keyStore;
    private final char[] password;

    public SmimeSignKeyStoreLoader(KeyStore keyStore, char[] password) {
        this.keyStore = keyStore;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SmimeSignKey loadInternalKey(String email) throws Exception {
        if (this.keyStore == null) {
            this.getInfoDataManager().send(new InfoData(200, new Object[0]));
            throw new IllegalArgumentException("Key Store must not be null.");
        }
        if (email == null) {
            this.getInfoDataManager().send(new InfoData(201, new Object[0]));
            throw new IllegalArgumentException("Email must not be null.");
        }
        KeyStoreContentFetcher fetcher = this.createContentFetcher();
        try {
            SmimeSignKey key = this.getValidKey(fetcher, email);
            this.addCertsForEmail(fetcher, key, email);
            this.buildCertChain(key);
            SmimeSignKey smimeSignKey = key;
            return smimeSignKey;
        }
        finally {
            fetcher.destroy();
        }
    }

    private KeyStoreContentFetcher createContentFetcher() {
        KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(this.keyStore);
        fetcher.keyPassword(this.password);
        return fetcher;
    }

    private SmimeSignKey getValidKey(KeyStoreContentFetcher fetcher, String email) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException {
        Logger log = this.getLog();
        log.info("Looking up valid S/MIME private key for email <{}> in private key store.", (Object)email);
        SmimeSignKey key = this.toBestKey(this.findValidPrivateKeys(fetcher, email), email);
        if (key.getKeyValidity() == EKeyValidity.NOT_FOUND) {
            log.info("Found no valid S/MIME private key for email <{}> in private key store.", (Object)email);
            this.getInfoDataManager().send(new InfoData(203, email));
        } else {
            log.info("Found valid S/MIME private key for email <{}> in private key store.", (Object)email);
            log.trace("Found certificate: {}", (Object)key.getKey());
            this.getInfoDataManager().send(new InfoData(202, email));
        }
        return key;
    }

    private Set<Map.Entry<X509Certificate, PrivateKey>> findValidPrivateKeys(KeyStoreContentFetcher fetcher, String email) throws KeyStoreException, UnrecoverableKeyException, NoSuchAlgorithmException {
        Predicate<X509Certificate> predEmail = SmimeUtil.createPredicateForEmail(email);
        Predicate<X509Certificate> predPurpose = SmimeUtil.createPredicateForPurpose(EKeyPurpose.SIGNING);
        Predicate<X509Certificate> predValidity = SmimeUtil::isCertCurrentlyValid;
        Predicate<X509Certificate> predCriticalExtension = this::isCritExtensionSatisfied;
        return fetcher.getEntriesFor(predEmail.and(predValidity).and(predPurpose).and(predCriticalExtension));
    }

    private SmimeSignKey toBestKey(Collection<Map.Entry<X509Certificate, PrivateKey>> privateKeys, String email) {
        Function<Map.Entry, SmimeSignKey> keyMapper = entry -> {
            SmimeSignKey key = new SmimeSignKey((PrivateKey)entry.getValue(), (X509Certificate)entry.getKey(), email);
            key.setKeySource(this.getKeySource());
            return key;
        };
        return this.findBest(privateKeys.stream().map(keyMapper), SmimeSignKey::getPublicCert);
    }

    private void addCertsForEmail(KeyStoreContentFetcher fetcher, SmimeSignKey key, String email) {
        if (!key.isValid()) {
            return;
        }
        this.getLog().debug("Looking up further valid certificates for <{}>.", (Object)email);
        try {
            Set<X509Certificate> certs = fetcher.getCertsFor(SmimeUtil.createPredicateForEmail(email).and(SmimeUtil::isCertCurrentlyValid));
            key.getAttachedCerts().addAll(certs);
        }
        catch (KeyStoreException e) {
            this.getLog().error("Could not lookup further certificates for <" + email + ">. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private void buildCertChain(SmimeSignKey key) throws KeyStoreException {
        if (!key.isValid()) {
            return;
        }
        Logger log = this.getLog();
        log.debug("Looking up intermediate certificates.");
        X509Certificate publicCert = key.getPublicCert();
        String alias = this.getKeyStore().getCertificateAlias(publicCert);
        Certificate[] chain = this.getKeyStore().getCertificateChain(alias);
        if (chain != null && chain.length > 1) {
            log.debug("Found {} intermediate certificate(s).", (Object)(chain.length - 2));
            for (int i = 1; i < chain.length - 1; ++i) {
                key.getAttachedCerts().add((X509Certificate)chain[i]);
            }
            X509Certificate lastCert = (X509Certificate)chain[chain.length - 1];
            if (!lastCert.getSubjectX500Principal().equals(lastCert.getIssuerX500Principal())) {
                key.getAttachedCerts().add(lastCert);
            }
            log.trace("Found intermediate certificates: {}", key.getAttachedCerts());
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Listing all certificates in key store.");
            Enumeration<String> ksAliases = this.getKeyStore().aliases();
            while (ksAliases.hasMoreElements()) {
                String ksAlias = ksAliases.nextElement();
                X509Certificate certCandidate = (X509Certificate)this.getKeyStore().getCertificate(ksAlias);
                log.trace("Alias: {}; Subject: {}; Issuer: {}", new Object[]{ksAlias, certCandidate.getSubjectX500Principal(), certCandidate.getIssuerX500Principal()});
            }
        }
        log.debug("Fallback lookup of intermediate certificates.");
        X509Certificate cert = publicCert;
        while (cert != null) {
            if ((cert = this.getIssuerCert(cert)) == null) continue;
            key.getAttachedCerts().add(cert);
        }
        log.trace("Found intermediate certificates: {}", key.getAttachedCerts());
    }

    private X509Certificate getIssuerCert(X509Certificate cert) throws KeyStoreException {
        X500Principal issuerDN = cert.getIssuerX500Principal();
        if (issuerDN.equals(cert.getSubjectX500Principal())) {
            return null;
        }
        X509Certificate issuer = (X509Certificate)this.getKeyStore().getCertificate(issuerDN.getName());
        if (issuer != null) {
            return issuer;
        }
        Enumeration<String> aliases = this.getKeyStore().aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            X509Certificate certCandidate = (X509Certificate)this.getKeyStore().getCertificate(alias);
            if (!certCandidate.getSubjectX500Principal().equals(issuerDN)) continue;
            return certCandidate;
        }
        return null;
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.KEYSTORE;
    }

    @Override
    protected SmimeSignKey getValidityKey(EKeyValidity validity) {
        return new SmimeSignKey(validity, this.getKeySource());
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public String toString() {
        return "SmimePrivateKeyStoreLoader [keyStore=" + this.keyStore + ", password=*****]";
    }
}

