/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpDecryptionKey
extends ACryptographyKey<PGPPrivateKey>
implements ISecretCryptographyKey<PGPPrivateKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpDecryptionKey.class);
    private PGPPrivateKey key;
    private PGPPublicKey publicKey;

    public PgpDecryptionKey(PGPPrivateKey key) {
        super(EKeyPurpose.DECRYPTION, ECryptographyType.PGP);
        this.key = key;
        if (key == null) {
            log.warn("Key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public PgpDecryptionKey(PGPPrivateKey privateKey, PGPPublicKey publicKey) {
        this(privateKey);
        this.publicKey = publicKey;
    }

    public PgpDecryptionKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public PgpDecryptionKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.DECRYPTION, ECryptographyType.PGP);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public PGPPrivateKey getKey() {
        return this.key;
    }

    public PGPPublicKey getPublicKey() {
        return this.publicKey;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.key = null;
        this.publicKey = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.key == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("PGP Decryption Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Public Key: ");
        builder.append(this.getPublicKey());
        return builder.toString();
    }
}

