/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor.specific;

import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Part;
import jakarta.mail.internet.ContentType;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMultipart;
import jakarta.mail.internet.MimePart;
import java.io.IOException;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.mail.visitor.ManipulateMessageVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1InputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;

public class OpaqueSignatureConverter
extends ManipulateMessageVisitor {
    @Override
    protected boolean isRelevant(ContentType type) {
        return type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime");
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        if (Boolean.parseBoolean(part.getHeader("X-Opaque-Signature-Converted", null))) {
            this.getLog().info("Opaque signature already converted in message with ID: {}", (Object)this.getMsgId());
            return;
        }
        ContentType type = new ContentType(part.getContentType());
        this.getLog().debug("Found '{}' content.", (Object)type);
        String smimeType = type.getParameter("smime-type");
        if (smimeType != null && !"signed-data".equalsIgnoreCase(smimeType)) {
            return;
        }
        if (!this.checkAsn1Type(part)) {
            return;
        }
        this.getLog().info("Converting opaque signature from message {} into clear signature.", (Object)this.getMsgId());
        MimeBodyPart signaturePart = new MimeBodyPart();
        MessageUtil.movePart((Part)part, (Part)signaturePart);
        signaturePart.setHeader("X-Opaque-Signature-Converted", Boolean.TRUE.toString());
        SMIMESigned smimeSigned = new SMIMESigned((Part)part);
        MimeBodyPart contentPart = smimeSigned.getContent();
        MimeMultipart mp = new MimeMultipart("signed; protocol=\"application/pkcs7-signature\"");
        mp.addBodyPart((BodyPart)contentPart);
        mp.addBodyPart((BodyPart)signaturePart);
        MessageUtil.removeMatchingHeaders((Part)part, Constants.STRUCTURAL_MIME_HEADERS);
        part.setContent((Multipart)mp);
        this.setChanged(true);
    }

    private boolean checkAsn1Type(MimePart part) throws IOException, MessagingException {
        ASN1Primitive asn1;
        try (ASN1InputStream is = new ASN1InputStream(part.getInputStream());){
            asn1 = is.readObject();
        }
        ContentInfo info = ContentInfo.getInstance(asn1);
        return info != null && "1.2.840.113549.1.7.2".equals(info.getContentType().toString());
    }
}

