/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.util.FilterIterator;
import net.savignano.cryptography.util.PgpKeyRingSplitter;
import net.savignano.cryptography.util.TransformIterator;
import net.savignano.thirdparty.org.bouncycastle.bcpg.ArmoredOutputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGOutputStream;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.KeyBox;
import net.savignano.thirdparty.org.bouncycastle.gpg.keybox.bc.BcKeyBox;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedDataList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPObjectFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPOnePassSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPOnePassSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignature;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureList;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDataEncryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPublicKeyKeyEncryptionMethodGenerator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpUtil {
    private static final Logger log = LoggerFactory.getLogger(PgpUtil.class);
    public static final String ERROR_MESSAGE_FOR_WRONG_PASSWORD = "checksum mismatch at in checksum of 20 bytes";

    public static final Comparator<PGPPublicKeyRing> getKeyRingComparator() {
        return Comparator.nullsLast(Comparator.comparing(PGPPublicKeyRing::getPublicKey, PgpUtil.getKeyComparator()));
    }

    public static final Comparator<PGPPublicKey> getKeyComparator() {
        return Comparator.nullsLast((k1, k2) -> {
            boolean valid2;
            Instant now = Instant.now();
            Instant since1 = k1.getCreationTime().toInstant();
            Instant since2 = k2.getCreationTime().toInstant();
            Instant until1 = k1.getValidSeconds() == 0L ? Instant.MAX : since1.plusSeconds(k1.getValidSeconds());
            Instant until2 = k2.getValidSeconds() == 0L ? Instant.MAX : since2.plusSeconds(k2.getValidSeconds());
            boolean valid1 = since1.isBefore(now) && until1.isAfter(now);
            boolean bl = valid2 = since2.isBefore(now) && until2.isAfter(now);
            if (valid1 == valid2) {
                int newer = since2.compareTo(since1);
                if (newer != 0) {
                    return newer;
                }
                return until2.compareTo(until1);
            }
            if (valid1) {
                return -1;
            }
            if (valid2) {
                return 1;
            }
            return 0;
        });
    }

    public static final PGPPrivateKey extractPrivateKey(PGPSecretKey key, char[] password) throws PGPException {
        return key.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(password));
    }

    public static final PGPPublicKeyRing loadPublicKey(InputStream is) throws IOException {
        return new PGPPublicKeyRing(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PUBLIC), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final PGPPublicKeyRingCollection loadPublicKeys(InputStream is) throws IOException, PGPException {
        return new PGPPublicKeyRingCollection(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PUBLIC), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final PGPSecretKeyRing loadSecretKey(InputStream is) throws IOException, PGPException {
        return new PGPSecretKeyRing(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PRIVATE), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final PGPSecretKeyRingCollection loadSecretKeys(InputStream is) throws IOException, PGPException {
        return new PGPSecretKeyRingCollection(PgpUtil.getPgpStream(is, PgpKeyRingSplitter.EPgpKeyRingSplitterType.PRIVATE), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    public static final KeyBox loadKeyBox(InputStream is) throws IOException {
        return new BcKeyBox(new BufferedInputStream(is));
    }

    private static final InputStream getPgpStream(InputStream is, PgpKeyRingSplitter.EPgpKeyRingSplitterType type) throws IOException {
        InputStream stream = is;
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        byte[] lookFor = "-----BEGIN PGP".getBytes(Constants.ASCII_CHARSET);
        stream.mark(lookFor.length);
        boolean isArmored = PgpUtil.isPgpArmored(stream, lookFor);
        stream.reset();
        if (isArmored) {
            PgpKeyRingSplitter reader = new PgpKeyRingSplitter(new InputStreamReader(stream, Constants.ASCII_CHARSET), type);
            stream = new ReaderInputStream((Reader)reader, Constants.ASCII_CHARSET);
        }
        return PGPUtil.getDecoderStream(stream);
    }

    public static final boolean isPgpArmored(InputStream is, String type) {
        byte[] lookFor = (type != null ? type : "-----BEGIN PGP").getBytes(Constants.ASCII_CHARSET);
        try {
            return PgpUtil.isPgpArmored(is, lookFor);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static final boolean isPgpArmored(InputStream is, byte[] lookFor) throws IOException {
        int toRead = lookFor.length;
        byte[] buffer = new byte[toRead];
        int read = IOUtils.read((InputStream)is, (byte[])buffer);
        return read == toRead && Arrays.equals(lookFor, buffer);
    }

    public static final boolean isSupportedSymmetricKeyAlgorithm(int algorithm) {
        return algorithm > 0 && algorithm < 14 && algorithm != 5 && algorithm != 6 && algorithm != 2;
    }

    public static final byte[] encrypt(byte[] bytes, PGPPublicKey publicKey, int algorithm, boolean acsiiArmored, boolean zip) throws IOException, PGPException {
        if (bytes == null) {
            return null;
        }
        if (publicKey == null) {
            throw new PGPException("No public key given to encrypt bytes.");
        }
        if (!PgpUtil.isSupportedSymmetricKeyAlgorithm(algorithm)) {
            throw new PGPException("Unsupported symmetric key algorithm for PGP encryption: " + PgpUtil.getSymmetricCipherName(algorithm) + " (" + algorithm + ")");
        }
        if (log.isDebugEnabled()) {
            log.debug("Encrypting for PGP key ID: {}", (Object)PgpUtil.getPrettyId(publicKey));
            log.debug("Symmetric key algorithm used: {} ({})", (Object)PgpUtil.getSymmetricCipherName(algorithm), (Object)algorithm);
            log.debug("ASCII Armored: {} / Zip: {}", (Object)acsiiArmored, (Object)zip);
        }
        return PgpUtil.encrypt(bytes, algorithm, acsiiArmored, zip, publicKey);
    }

    public static final byte[] encrypt(byte[] bytes, PGPPublicKey[] publicKeys, int algorithm, boolean acsiiArmored, boolean zip) throws IOException, PGPException {
        if (bytes == null) {
            return null;
        }
        if (publicKeys == null || publicKeys.length == 0) {
            throw new PGPException("No public key(s) given to encrypt bytes.");
        }
        if (!PgpUtil.isSupportedSymmetricKeyAlgorithm(algorithm)) {
            throw new PGPException("Unsupported symmetric key algorithm for PGP encryption: " + PgpUtil.getSymmetricCipherName(algorithm) + " (" + algorithm + ")");
        }
        if (log.isDebugEnabled()) {
            Object[] ids = new String[publicKeys.length];
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = PgpUtil.getPrettyId(publicKeys[i]);
            }
            log.debug("Encrypting for PGP key ID(s): {}", (Object)StringUtils.join((Object[])ids, (String)";"));
            log.debug("Symmetric key algorithm used: {} ({})", (Object)PgpUtil.getSymmetricCipherName(algorithm), (Object)algorithm);
            log.debug("ASCII Armored: {} / Zip: {}", (Object)acsiiArmored, (Object)zip);
        }
        return PgpUtil.encrypt(bytes, algorithm, acsiiArmored, zip, publicKeys);
    }

    private static final byte[] encrypt(byte[] bytes, int algorithm, boolean acsiiArmored, boolean zip, PGPPublicKey ... publicKeys) throws IOException, PGPException {
        ByteArrayOutputStream byteOut;
        block51: {
            byteOut = new ByteArrayOutputStream();
            try (OutputStream out = acsiiArmored ? PgpUtil.getAsciiArmoredStream(byteOut) : byteOut;){
                BcPGPDataEncryptorBuilder encBuilder = new BcPGPDataEncryptorBuilder(algorithm);
                encBuilder.setWithIntegrityPacket(true);
                PGPEncryptedDataGenerator encDataGen = new PGPEncryptedDataGenerator(encBuilder);
                for (PGPPublicKey publicKey : publicKeys) {
                    BcPublicKeyKeyEncryptionMethodGenerator encMethodGen = new BcPublicKeyKeyEncryptionMethodGenerator(publicKey);
                    encDataGen.addMethod(encMethodGen);
                }
                try (OutputStream encDataGenOut = encDataGen.open(out, new byte[65536]);){
                    if (zip) {
                        PGPCompressedDataGenerator comDataGen = new PGPCompressedDataGenerator(1);
                        OutputStream comDataOut = comDataGen.open(encDataGenOut);
                        PGPLiteralDataGenerator lDataGen = new PGPLiteralDataGenerator();
                        try (OutputStream lDataOut = lDataGen.open(comDataOut, 'b', "_CONSOLE", PGPLiteralData.NOW, new byte[1024]);){
                            lDataOut.write(bytes);
                        }
                        comDataGen.close();
                        break block51;
                    }
                    PGPLiteralDataGenerator lDataGen = new PGPLiteralDataGenerator();
                    try (OutputStream lDataOut = lDataGen.open(encDataGenOut, 'b', "_CONSOLE", PGPLiteralData.NOW, new byte[1024]);){
                        lDataOut.write(bytes);
                    }
                }
            }
        }
        return byteOut.toByteArray();
    }

    private static final OutputStream getAsciiArmoredStream(OutputStream toWrap) {
        ArmoredOutputStream.Builder builder = ArmoredOutputStream.builder();
        if (log.isDebugEnabled()) {
            builder.setVersion("BCPG v1.78.1");
        }
        return builder.build(toWrap);
    }

    public static final byte[] decrypt(InputStream encrypted, PGPSecretKeyRingCollection pgpSecretKeyRingCollection, char[] keyPassword) throws IOException, PGPException {
        if (encrypted == null) {
            return null;
        }
        if (pgpSecretKeyRingCollection == null || pgpSecretKeyRingCollection.size() == 0) {
            throw new PGPException("No secret key(s) given to decrypt bytes.");
        }
        GetKeyFunction<PGPPrivateKey> privateKeyFunction = id -> {
            PGPSecretKey secretKey = pgpSecretKeyRingCollection.getSecretKey(id);
            if (secretKey != null) {
                return PgpUtil.extractPrivateKey(secretKey, keyPassword);
            }
            return null;
        };
        log.debug("Decrypting PGP message");
        try (InputStream decoderStream = PGPUtil.getDecoderStream(encrypted);){
            byte[] byArray = PgpUtil.decryptStream(decoderStream, privateKeyFunction);
            return byArray;
        }
    }

    public static final byte[] decrypt(InputStream encrypted, GetKeyFunction<PGPPrivateKey> decryptionKeyFunction) throws IOException, PGPException {
        if (encrypted == null) {
            return null;
        }
        if (decryptionKeyFunction == null) {
            throw new PGPException("No secret key(s) given to decrypt bytes.");
        }
        log.debug("Decrypting PGP message");
        try (InputStream decoderStream = PGPUtil.getDecoderStream(encrypted);){
            byte[] byArray = PgpUtil.decryptStream(decoderStream, decryptionKeyFunction);
            return byArray;
        }
    }

    private static byte[] decryptStream(InputStream stream, GetKeyFunction<PGPPrivateKey> decryptionKeyFunction) throws IOException, PGPException {
        Iterator<PGPPublicKeyEncryptedData> iter = PgpUtil.getEncryptionInformation(stream);
        PGPPrivateKey privateKey = null;
        PGPPublicKeyEncryptedData publicEncData = null;
        while (privateKey == null && iter.hasNext()) {
            publicEncData = iter.next();
            log.debug("Looking up private key for ID: {}", (Object)PgpUtil.getPrettyId(publicEncData.getKeyID()));
            try {
                privateKey = decryptionKeyFunction.apply(publicEncData.getKeyID());
            }
            catch (PGPException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (privateKey == null || publicEncData == null) {
            throw new PGPException("Found no private key to decrypt message.");
        }
        return PgpUtil.decrypt(publicEncData, privateKey);
    }

    public static Iterator<PGPPublicKeyEncryptedData> getEncryptionInformation(InputStream stream) throws PGPException, IOException {
        BcKeyFingerprintCalculator fingerPrintCalculator = new BcKeyFingerprintCalculator();
        PGPObjectFactory pgpFactory = new PGPObjectFactory(stream, (KeyFingerPrintCalculator)fingerPrintCalculator);
        Object obj = pgpFactory.nextObject();
        PGPEncryptedDataList encDataList = obj instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)obj : (PGPEncryptedDataList)pgpFactory.nextObject();
        if (encDataList == null) {
            throw new PGPException("Found no encrypted data.");
        }
        Iterator<PGPEncryptedData> encDataIter = encDataList.getEncryptedDataObjects();
        FilterIterator<PGPEncryptedData> filterTier = new FilterIterator<PGPEncryptedData>(encDataIter, data -> {
            if (data instanceof PGPPublicKeyEncryptedData) {
                return true;
            }
            log.info("Skipping unsupported encryption data: {}", data);
            return false;
        });
        TransformIterator<PGPEncryptedData, PGPPublicKeyEncryptedData> transformIter = new TransformIterator<PGPEncryptedData, PGPPublicKeyEncryptedData>(filterTier, data -> (PGPPublicKeyEncryptedData)data);
        return transformIter;
    }

    public static byte[] decrypt(PGPPublicKeyEncryptedData encryptedData, PGPPrivateKey privateKey) throws IOException, PGPException {
        BcKeyFingerprintCalculator fingerPrintCalculator = new BcKeyFingerprintCalculator();
        BcPublicKeyDataDecryptorFactory decFactory = new BcPublicKeyDataDecryptorFactory(privateKey);
        int symmetricKeyAlgorithm = encryptedData.getSymmetricAlgorithm(decFactory);
        if (!PgpUtil.isSupportedSymmetricKeyAlgorithm(symmetricKeyAlgorithm)) {
            throw new PGPException("Unsupported symmetric key algorithm for PGP decryption: " + PgpUtil.getSymmetricCipherName(symmetricKeyAlgorithm) + " (" + symmetricKeyAlgorithm + ")");
        }
        try (InputStream encDataIn = encryptedData.getDataStream(decFactory);){
            byte[] decryptedBytes;
            PGPObjectFactory objFact = new PGPObjectFactory(encDataIn, (KeyFingerPrintCalculator)fingerPrintCalculator);
            Object message = objFact.nextObject();
            if (message instanceof PGPCompressedData) {
                log.debug("Found compressed data. Decompressing.");
                PGPCompressedData compressedData = (PGPCompressedData)message;
                objFact = new PGPObjectFactory(compressedData.getDataStream(), (KeyFingerPrintCalculator)fingerPrintCalculator);
                message = objFact.nextObject();
            }
            if (message instanceof PGPOnePassSignatureList) {
                PGPOnePassSignatureList sigList = (PGPOnePassSignatureList)message;
                log.debug("One pass signature list encountered. Contained number of signatures: {}", (Object)sigList.size());
                for (PGPOnePassSignature sig : sigList) {
                    log.debug("Found signature for key ID: {}", (Object)PgpUtil.getPrettyId(sig.getKeyID()));
                }
                message = objFact.nextObject();
            }
            if (message instanceof PGPLiteralData) {
                log.debug("Decrypting message.");
                PGPLiteralData literalData = (PGPLiteralData)message;
                try (InputStream literalDataIn = literalData.getInputStream();){
                    int ch;
                    ByteArrayOutputStream decOut = new ByteArrayOutputStream();
                    while ((ch = literalDataIn.read()) >= 0) {
                        decOut.write(ch);
                    }
                    decryptedBytes = decOut.toByteArray();
                }
            } else {
                throw new PGPException("Expected PGP literal data package, but got unknown package instead: " + message);
            }
            if (encryptedData.isIntegrityProtected()) {
                log.debug("Checking integrity of message.");
                if (encryptedData.verify()) {
                    log.debug("Integrity check of message successful.");
                } else {
                    throw new PGPException("Integrity violation detected. Message has been tampered with.");
                }
            }
            Object object = decryptedBytes;
            return object;
        }
    }

    public static final byte[] sign(byte[] bytes, PGPSecretKey key, char[] password, int algorithm, boolean acsiiArmored) throws IOException, PGPException {
        if (log.isDebugEnabled()) {
            log.debug("Signing with PGP key ID: {}", (Object)PgpUtil.getPrettyId(key));
            log.debug("ASCII Armored: {}", (Object)acsiiArmored);
        }
        PGPPublicKey publicKey = key.getPublicKey();
        PGPPrivateKey privateKey = PgpUtil.extractPrivateKey(key, password);
        BcPGPContentSignerBuilder builder = new BcPGPContentSignerBuilder(publicKey.getAlgorithm(), algorithm);
        PGPSignatureGenerator signatureGenerator = new PGPSignatureGenerator(builder);
        signatureGenerator.init(1, privateKey);
        String userId = publicKey.getUserIDs().next();
        PGPSignatureSubpacketGenerator subGenerator = new PGPSignatureSubpacketGenerator();
        subGenerator.addSignerUserID(false, userId);
        signatureGenerator.setHashedSubpackets(subGenerator.generate());
        signatureGenerator.update(bytes);
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try (BCPGOutputStream sigOut = new BCPGOutputStream(acsiiArmored ? new ArmoredOutputStream(bOut) : bOut);){
            signatureGenerator.generate().encode(sigOut);
        }
        return bOut.toByteArray();
    }

    public static final boolean verify(byte[] contentBytes, byte[] signatureBytes, PGPPublicKey publicKey) throws IOException, PGPException {
        log.debug("Verifying signature with key ID: {}", (Object)PgpUtil.getPrettyId(publicKey));
        GetKeyFunction<PGPPublicKey> keyFunction = id -> publicKey.getKeyID() == id.longValue() ? publicKey : null;
        return PgpUtil.verify(contentBytes, signatureBytes, keyFunction);
    }

    public static final boolean verify(byte[] contentBytes, byte[] signatureBytes, GetKeyFunction<PGPPublicKey> publicKeyFunction) throws IOException, PGPException {
        log.debug("Reading signature.");
        try (InputStream is = PGPUtil.getDecoderStream(new ByteArrayInputStream(signatureBytes));){
            BcPGPObjectFactory factory = new BcPGPObjectFactory(is);
            PGPSignatureList sigList = (PGPSignatureList)factory.nextObject();
            PGPSignature sig = sigList.get(0);
            log.debug("Looking up public key with ID: {}", (Object)PgpUtil.getPrettyId(sig.getKeyID()));
            PGPPublicKey publicKey = publicKeyFunction.apply(sig.getKeyID());
            if (publicKey == null) {
                log.info("Verifying signature failed, as no public key with ID \"{}\" could be found.", (Object)PgpUtil.getPrettyId(sig.getKeyID()));
                boolean bl = false;
                return bl;
            }
            if (sig.getKeyAlgorithm() != publicKey.getAlgorithm()) {
                log.info("Verifying signature failed, as public key's algorithm is not the same as algorithm of signature. Signature / Key: {} / {}", (Object)sig.getKeyAlgorithm(), (Object)publicKey.getAlgorithm());
                boolean bl = false;
                return bl;
            }
            sig.init(new BcPGPContentVerifierBuilderProvider(), publicKey);
            sig.update(contentBytes);
            boolean bl = sig.verify();
            return bl;
        }
    }

    public static final int[] getPreferredSymmetricKeyAlgorithms(PGPPublicKeyRing ring) {
        if (ring == null) {
            return new int[0];
        }
        return PgpUtil.getPreferredSymmetricKeyAlgorithms(ring.getPublicKey());
    }

    public static final int[] getPreferredSymmetricKeyAlgorithms(PGPPublicKey key) {
        if (key == null) {
            return new int[0];
        }
        PGPSignature signature = PgpUtil.getMatchingSignature(key);
        if (signature != null) {
            PGPSignatureSubpacketVector subPacket = signature.getHashedSubPackets();
            if (subPacket != null) {
                int[] preferredSymmetricAlgorithms = subPacket.getPreferredSymmetricAlgorithms();
                if (preferredSymmetricAlgorithms != null) {
                    log.debug("Preferred symmetric algorithms: {}", (Object)Arrays.toString(preferredSymmetricAlgorithms));
                    return preferredSymmetricAlgorithms;
                }
                log.debug("No preferred symmetric algorithms encountered.");
            } else {
                log.debug("No hashed sup packet encountered.");
            }
        }
        log.warn("No preferred symmetric key algorithms found for key with ID: {}", (Object)PgpUtil.getPrettyId(key));
        return new int[0];
    }

    private static PGPSignature getMatchingSignature(PGPPublicKey key) {
        long keyId = key.getKeyID();
        for (int certType : new int[]{19, 18, 17, 16}) {
            Iterator<PGPSignature> signatures = key.getSignaturesOfType(certType);
            while (signatures.hasNext()) {
                PGPSignature signature = signatures.next();
                if (keyId != signature.getKeyID()) continue;
                return signature;
            }
        }
        return null;
    }

    public static final PGPPublicKeyRing getKeysForEmail(PGPPublicKeyRingCollection coll, String email) {
        log.debug("Looking up key ring for email <{}>.", (Object)email);
        if (coll == null || email == null) {
            return null;
        }
        for (PGPPublicKeyRing ring : coll) {
            PGPPublicKey key = ring.getPublicKey();
            if (key == null || !key.isMasterKey()) {
                log.warn("Passed key ring collection contains a ring without a corresponding master key. Maybe key ring is corrupt.");
                continue;
            }
            if (!PgpUtil.isKeyForEmail(key, email)) continue;
            log.debug("Key with ID {} matches email.", (Object)PgpUtil.getPrettyId(key));
            return ring;
        }
        log.debug("Key ring for email <{}> was not found.", (Object)email);
        return null;
    }

    public static final PGPSecretKeyRing getKeysForEmail(PGPSecretKeyRingCollection coll, String email) {
        log.debug("Looking up key ring for email <{}>.", (Object)email);
        if (coll == null || email == null) {
            return null;
        }
        for (PGPSecretKeyRing ring : coll) {
            PGPSecretKey key = ring.getSecretKey();
            if (key == null || !key.isMasterKey()) {
                log.warn("Passed key ring collection contains a ring without a corresponding master key. Maybe key ring is corrupt.");
                continue;
            }
            if (!PgpUtil.isKeyForEmail(key, email)) continue;
            log.debug("Key with ID {} matches email.", (Object)PgpUtil.getPrettyId(key));
            return ring;
        }
        log.debug("Key ring for email <{}> was not found.", (Object)email);
        return null;
    }

    public static final boolean isKeyForEmail(PGPPublicKey key, String email) {
        log.debug("Checking whether key with ID {} is valid for email <{}>.", (Object)PgpUtil.getPrettyId(key), (Object)email);
        if (key == null || email == null) {
            log.debug("Key is not valid.");
            return false;
        }
        return PgpUtil.isKeyForEmail(key.getUserIDs(), email);
    }

    public static final boolean isKeyForEmail(PGPSecretKey key, String email) {
        log.debug("Checking whether key with ID {} is valid for email <{}>.", (Object)PgpUtil.getPrettyId(key), (Object)email);
        if (key == null || email == null) {
            log.debug("Key is not valid.");
            return false;
        }
        return PgpUtil.isKeyForEmail(key.getUserIDs(), email);
    }

    private static final boolean isKeyForEmail(Iterator<String> iter, String email) {
        String lcEmail = email.toLowerCase(Locale.ROOT);
        while (iter.hasNext()) {
            String userId = iter.next().toLowerCase(Locale.ROOT);
            log.trace("Checking user ID: {}", (Object)userId);
            if (!userId.contains(lcEmail)) continue;
            log.debug("Key is valid.");
            return true;
        }
        log.debug("Key is not valid.");
        return false;
    }

    public static final String getPrettyId(PGPPublicKey key) {
        if (key == null) {
            return null;
        }
        return PgpUtil.getPrettyId(key.getKeyID());
    }

    public static final String getPrettyId(PGPSecretKey key) {
        if (key == null) {
            return null;
        }
        return PgpUtil.getPrettyId(key.getKeyID());
    }

    public static final String getPrettyId(long id) {
        return Long.toHexString(id).toUpperCase(Locale.ROOT);
    }

    public static final String getSymmetricCipherName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return "No Cipher";
            }
            case 1: {
                return "IDEA";
            }
            case 2: {
                return "Triple DES";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES 128";
            }
            case 8: {
                return "AES 192";
            }
            case 9: {
                return "AES 256";
            }
            case 10: {
                return "Twofish";
            }
            case 11: {
                return "Camellia 128";
            }
            case 12: {
                return "Camellia 192";
            }
            case 13: {
                return "Camellia 256";
            }
        }
        return "Unknown (" + algorithm + ")";
    }

    public static final String getHashName(int algorithm) {
        switch (algorithm) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
            case 6: {
                return "TIGER";
            }
        }
        return "Unknown (" + algorithm + ")";
    }

    public static final String getCompressionName(int algorithm) {
        switch (algorithm) {
            case 0: {
                return "Uncompressed";
            }
            case 1: {
                return "ZIP";
            }
            case 2: {
                return "ZLIB";
            }
            case 3: {
                return "BZIP2";
            }
        }
        return "Unknown (" + algorithm + ")";
    }

    @FunctionalInterface
    public static interface GetKeyFunction<R> {
        public R apply(Long var1) throws IOException, PGPException;
    }
}

