/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.key.info;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.key.info.AKeyInfoBuilder;
import net.savignano.snotify.atlassian.gui.key.info.IKeyValueStyle;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.util.encoders.Hex;
import org.apache.commons.lang3.StringUtils;

public class PgpPublicKeyInfoBuilder
extends AKeyInfoBuilder {
    public static final String CRYPTOGRAPHY_TYPE_ID = "type-pgp";
    public static final String UPLOAD_TIME_ID = "key-uploadTime";
    public static final String SOURCE_ID = "key-uploadBy";
    public static final String VALID_SINCE_ID = "key-valid";
    public static final String VALID_UNTIL_ID = "key-expires";
    public static final String MASTER_KEY_ID_ID = "key-id";
    public static final String MASTER_KEY_FINGERPRINT_ID = "key-fingerprint";
    public static final String ENCRYPTION_KEY_ID_ID = "key-encryption";
    public static final String USERS_ID = "key-users";
    private final PGPPublicKeyRing ring;
    private final Long keyId;

    public PgpPublicKeyInfoBuilder(PGPPublicKeyRing ring, Long keyId, ISnotifyI18n i18n) throws PGPException {
        super(i18n);
        this.ring = ring;
        this.keyId = keyId;
        if (ring == null) {
            throw new IllegalArgumentException("Key ring must not be null.");
        }
        if (keyId != null && ring.getPublicKey(keyId) == null) {
            throw new PGPException("No public key found for ID: " + PgpUtil.getPrettyId(keyId));
        }
    }

    public PgpPublicKeyInfoBuilder(byte[] key, long keyId, ISnotifyI18n i18n) throws IOException, PGPException {
        this(PgpUtil.loadPublicKey(new ByteArrayInputStream(key)), (Long)keyId, i18n);
    }

    @Override
    public String build(IKeyValueStyle style) {
        PGPPublicKey encKey;
        StringBuilder builder = new StringBuilder(1000);
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.type"), this.getI18n().getText("net.savignano.snotify.info-builder.pgp.type"), CRYPTOGRAPHY_TYPE_ID));
        if (this.getUser() != null && this.getUserProps() != null) {
            Long timeStamp = this.getUserProps().getLong(EProperty.EMAIL_PGP_TIME_STAMP, this.getUser());
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.uploadTime"), timeStamp == null ? "N/A" : this.getI18n().formatDateTime(new Date(timeStamp), FormatStyle.MEDIUM), UPLOAD_TIME_ID));
            EKeySource keySource = this.getUserProps().getEnum(EProperty.EMAIL_PGP_KEY_SOURCE, EKeySource.class, this.getUser());
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.uploadBy"), keySource == null ? "N/A" : this.getI18n().getText("net.savignano.snotify.upload-key-source." + keySource.name()), SOURCE_ID));
        }
        PGPPublicKey masterKey = this.ring.getPublicKey();
        PGPPublicKey pGPPublicKey = encKey = this.keyId == null ? null : this.ring.getPublicKey(this.keyId);
        if (encKey == null) {
            encKey = masterKey;
        }
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.valid"), this.getI18n().formatDateTime(masterKey.getCreationTime(), FormatStyle.MEDIUM), VALID_SINCE_ID));
        if (encKey.getValidSeconds() == 0L) {
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.expires"), this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.expires.never"), VALID_UNTIL_ID));
        } else {
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.expires"), this.getI18n().formatDateTime(new Date(encKey.getCreationTime().getTime() + encKey.getValidSeconds() * 1000L), FormatStyle.MEDIUM), VALID_UNTIL_ID));
        }
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.id"), PgpUtil.getPrettyId(masterKey), MASTER_KEY_ID_ID));
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.fingerprint"), this.getPrettyPrintFingerprint(masterKey.getFingerprint()), MASTER_KEY_FINGERPRINT_ID));
        if (encKey.getKeyID() != masterKey.getKeyID()) {
            builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.encKeyId"), PgpUtil.getPrettyId(encKey), ENCRYPTION_KEY_ID_ID));
        }
        ArrayList<String> users = new ArrayList<String>();
        Iterator<String> iter = masterKey.getUserIDs();
        while (iter.hasNext()) {
            users.add(iter.next());
        }
        builder.append(style.build(this.getI18n().getText("net.savignano.snotify.info-builder.pgp.key.users"), StringUtils.join(users, (String)", "), USERS_ID));
        return builder.toString();
    }

    private String getPrettyPrintFingerprint(byte[] fingerprint) {
        String full = Hex.toHexString(fingerprint).toUpperCase();
        StringBuilder builder = new StringBuilder(full.length() + full.length() / 4);
        int space = -1;
        for (char c : full.toCharArray()) {
            if (++space == 4) {
                builder.append(' ');
                space = 0;
            }
            builder.append(c);
        }
        return builder.toString();
    }
}

