/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatusType;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import org.apache.commons.lang3.StringUtils;

public class VerificationStatusBuilder {
    private final ISnotifyI18n i18n;
    private String title;
    private String subTitle;
    private String message;
    private EVerificationStatusType status;

    public VerificationStatusBuilder(ISnotifyI18n i18n) {
        this.i18n = i18n;
        if (i18n == null) {
            throw new IllegalArgumentException("I18n must not be null.");
        }
    }

    public ISnotifyI18n getI18n() {
        return this.i18n;
    }

    public void status(EVerificationStatusType status) {
        this.status = status;
    }

    public void success() {
        this.status(EVerificationStatusType.SUCCESS);
    }

    public void info() {
        this.status(EVerificationStatusType.INFO);
    }

    public void warning() {
        this.status(EVerificationStatusType.WARNING);
    }

    public void error() {
        this.status(EVerificationStatusType.ERROR);
    }

    public void title(String key, Object ... values) {
        this.title = this.i18n.getText(key, values);
    }

    public void subTitle(String key, Object ... values) {
        this.subTitle = this.i18n.getText(key, values);
    }

    public void message(String key, Object ... values) {
        this.message = this.i18n.getText(key, values);
    }

    public VerificationStatus build() {
        VerificationStatus verStatus = new VerificationStatus();
        verStatus.type = this.status;
        verStatus.message = this.message;
        verStatus.title = StringUtils.isNotBlank((CharSequence)this.subTitle) ? this.title + ": " + this.subTitle : this.title;
        return verStatus;
    }
}

