/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification;

import com.atlassian.velocity.htmlsafe.HtmlSafe;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatusType;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import org.apache.commons.text.StringEscapeUtils;

public class VerificationStatusDisplay {
    public static final String STATUS_HTML_ID = "verification-status";
    public static final String TITLE_HTML_ID = "verification-title";
    public static final String MESSAGE_HTML_ID = "verification-message";
    public static final String GENERIC_STATUS_HTML = "aui-message-generic";
    public static final String SUCCESS_STATUS_HTML = "aui-message-success";
    public static final String INFO_STATUS_HTML = "aui-message-info";
    public static final String WARNING_STATUS_HTML = "aui-message-warning";
    public static final String ERROR_STATUS_HTML = "aui-message-error";

    @HtmlSafe
    public static final String getHtml(VerificationStatus status) {
        StringBuilder builder = new StringBuilder(512);
        builder.append("<div id=\"");
        builder.append(STATUS_HTML_ID);
        builder.append("\" class=\"aui-message ");
        builder.append(VerificationStatusDisplay.getHtmlStatusCode(status.type));
        builder.append("\">\n");
        if (status.title != null) {
            builder.append("<p id=\"");
            builder.append(TITLE_HTML_ID);
            builder.append("\" class=\"title\"><strong>");
            builder.append(StringEscapeUtils.escapeHtml4((String)status.title));
            builder.append("</strong></p>\n");
        }
        if (status.message != null) {
            builder.append("<p id=\"");
            builder.append(MESSAGE_HTML_ID);
            builder.append("\">");
            builder.append(StringEscapeUtils.escapeHtml4((String)status.message));
            builder.append("</p>\n");
        }
        builder.append("</div>");
        return builder.toString();
    }

    private static final String getHtmlStatusCode(EVerificationStatusType status) {
        if (status == null) {
            return GENERIC_STATUS_HTML;
        }
        switch (status) {
            case ERROR: {
                return ERROR_STATUS_HTML;
            }
            case INFO: {
                return INFO_STATUS_HTML;
            }
            case SUCCESS: {
                return SUCCESS_STATUS_HTML;
            }
            case WARNING: {
                return WARNING_STATUS_HTML;
            }
        }
        return GENERIC_STATUS_HTML;
    }
}

