/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.pgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.pgp.PgpSignKeyStoreLoader;
import net.savignano.cryptography.key.pgp.PgpSignKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatusType;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyDecryptorBuilder;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpPrivateKeyStoreVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(PgpPrivateKeyStoreVerification.class);
    private final String location;
    private final Set<String> emails = new LinkedHashSet<String>();
    private char[] password;

    public PgpPrivateKeyStoreVerification(String location, ISnotifyI18n i18n) {
        super(i18n);
        if (location == null) {
            throw new IllegalArgumentException("Location must not be null.");
        }
        this.location = location;
        this.getBuilder().title("net.savignano.snotify.key-management.verification.pgp.private-keystore.title", new Object[0]);
    }

    @Override
    protected void doVerify() throws Exception {
        this.canReadLocation();
    }

    private void canReadLocation() {
        Exception e = null;
        boolean canRead = false;
        try {
            canRead = new File(this.location).canRead();
            log.debug("Can access key store at location {}: {}", (Object)this.location, (Object)canRead);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Cannot access key store location: " + this.location, (Throwable)e);
        }
        if (canRead) {
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.success.message", this.location);
            this.build();
            this.loadKeyStore();
        } else if (e != null) {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.exception.message", this.location, e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.canRead.failure.message", this.location);
            this.build();
        }
    }

    private void loadKeyStore() {
        Exception e = null;
        PGPSecretKeyRingCollection krColl = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.location));){
            krColl = PgpUtil.loadSecretKeys(is);
            log.debug("Could load key store from location: {}", (Object)this.location);
        }
        catch (Exception e1) {
            e = e1;
            log.debug("Could not load key store from location: " + this.location, (Throwable)e);
        }
        if (e == null) {
            if (krColl == null || krColl.size() == 0) {
                this.getBuilder().error();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.empty.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.empty.message", new Object[0]);
                this.build();
            } else {
                this.getBuilder().success();
                this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.success.title", new Object[0]);
                this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.success.message", krColl.size());
                this.build();
                this.checkEmail(krColl);
            }
        } else {
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.exception.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.loadKeyStore.exception.message", e.getClass().getSimpleName(), e.getLocalizedMessage());
            this.build();
        }
    }

    private void checkEmail(PGPSecretKeyRingCollection keyRingColl) {
        if (keyRingColl == null) {
            return;
        }
        if (this.getEmails().isEmpty()) {
            log.debug("No email address was given, so can't check if a key was found for it.");
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.noServer.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.noServer.message", new Object[0]);
            this.build();
            return;
        }
        for (String email : this.getEmails()) {
            this.setReportKey(false);
            this.verifyLoader(keyRingColl, email);
        }
    }

    private void checkPassword(PgpSignKey key) {
        if (this.getPassword() == null) {
            log.debug("No password was given, so cannot check if password is correct.");
            this.getBuilder().info();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkPassword.noPassword.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkPassword.noPassword.message", new Object[0]);
            this.build();
            return;
        }
        PGPSecretKey secretKey = key.getKey();
        if (secretKey == null) {
            log.debug("No signing key found, so cannot check if password is correct.");
            return;
        }
        try {
            PGPPrivateKey privateKey = secretKey.extractPrivateKey(new BcPBESecretKeyDecryptorBuilder(new BcPGPDigestCalculatorProvider()).build(this.getPassword()));
            log.debug("Key with ID {} could be extraced with given password.", (Object)PgpUtil.getPrettyId(privateKey.getKeyID()));
            this.getBuilder().success();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkPassword.success.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkPassword.success.message", PgpUtil.getPrettyId(secretKey));
            this.build();
            this.setReportKey(true);
        }
        catch (Exception e) {
            log.debug("Could not open key key with given password.", (Throwable)e);
            this.getBuilder().error();
            this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkPassword.failure.title", new Object[0]);
            this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkPassword.failure.message", PgpUtil.getPrettyId(secretKey));
            this.build();
        }
    }

    private void verifyLoader(PGPSecretKeyRingCollection keyRingColl, String email) {
        Consumer<InfoData> consumer = this::handleInfoData;
        PgpSignKeyStoreLoader loader = new PgpSignKeyStoreLoader(keyRingColl, this.getPassword());
        loader.getInfoDataManager().register(consumer);
        loader.loadKey(email);
        loader.getInfoDataManager().unregister(consumer);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                if (!this.getStatusList().isEmpty() && this.getStatusList().get((int)(this.getStatusList().size() - 1)).type == EVerificationStatusType.SUCCESS) {
                    this.checkPassword((PgpSignKey)data.additionalData[0]);
                }
                this.verifyKey((ICryptographyKey)data.additionalData[0]);
                break;
            }
            case 200: 
            case 201: {
                break;
            }
            case 202: {
                this.emailFound((String)data.additionalData[0]);
                break;
            }
            case 203: {
                this.emailNotFound((String)data.additionalData[0]);
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }

    private void emailFound(String email) {
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.success.message", email);
        this.build();
    }

    private void emailNotFound(String email) {
        this.getBuilder().warning();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.pgp.keystore.checkEmail.failure.message", email);
        this.build();
    }

    public Set<String> getEmails() {
        return this.emails;
    }

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = password;
    }
}

