/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.mail.MailFactory;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.user.User;
import java.util.Locale;
import net.savignano.cryptography.version.NormalizedVersion;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.templates.IAdminTemplate;
import net.savignano.snotify.atlassian.gui.templates.IUpdatedTemplate;
import net.savignano.snotify.confluence.common.SnotifyAppProperties;
import net.savignano.snotify.confluence.common.SnotifyI18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnotifyAdminSettingsAction
extends ConfluenceActionSupport
implements IAdminTemplate,
IUpdatedTemplate {
    private static final long serialVersionUID = 2369607869773471446L;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private ISnotifyAppProperties appProps;
    private ISnotifyI18n i18n;
    private boolean showUpdated;

    protected Logger getLog() {
        return this.log;
    }

    public boolean hasAdminRights() {
        return ((PermissionManager)ComponentLocator.getComponent(PermissionManager.class)).isSystemAdministrator(this.getAuthenticatedUser());
    }

    public ISnotifyAppProperties getAppProps() {
        if (this.appProps == null) {
            this.appProps = new SnotifyAppProperties();
        }
        return this.appProps;
    }

    public ISnotifyI18n getSnotifyI18n() {
        if (this.i18n == null) {
            LocaleManager localeManager = (LocaleManager)ComponentLocator.getComponent(LocaleManager.class);
            Locale locale = localeManager.getLocale((User)this.getAuthenticatedUser());
            this.i18n = new SnotifyI18n(this.getI18n(), locale);
        }
        return this.i18n;
    }

    @Override
    public String getGetStartedLink() {
        SystemInformationService service = (SystemInformationService)ComponentLocator.getComponent(SystemInformationService.class);
        String baseUrl = service.getConfluenceInfo().getBaseUrl();
        return baseUrl + "/plugins/snotify/snotify-installation-guide.action";
    }

    @Override
    public boolean isMailerLibPresent() {
        return this.getMailerVersion() != null;
    }

    @Override
    public boolean isVersionMatch() {
        if (!this.getAppProps().getBoolean(EProperty.DEV_MODE)) {
            return IAdminTemplate.super.isVersionMatch();
        }
        NormalizedVersion guiVersion = new NormalizedVersion(this.getGuiVersion());
        NormalizedVersion mailerVersion = new NormalizedVersion(this.getMailerVersion());
        return guiVersion.equals(mailerVersion);
    }

    @Override
    public boolean isMailServerPresent() {
        return MailFactory.getServerManager().getDefaultSMTPMailServer() != null;
    }

    @Override
    public String getGuiVersion() {
        return this.getAppProps().getString(EProperty.GUI_VERSION);
    }

    @Override
    public String getMailerVersion() {
        return this.getAppProps().getString(EProperty.MAILER_VERSION);
    }

    @Override
    public boolean isDisabled() {
        return this.getAppProps().getBoolean(EProperty.DISABLE_SNOTIFY);
    }

    @Override
    public boolean isFrozen() {
        return this.getAppProps().getBoolean(EProperty.FREEZE_SNOTIFY);
    }

    public boolean isLiteMode() {
        return this.getAppProps().getBoolean(EProperty.LITE_MODE);
    }

    @Override
    public boolean isShowUpdated() {
        return this.showUpdated;
    }

    public void setShowUpdated(boolean showUpdated) {
        this.showUpdated = showUpdated;
    }
}

