/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.confluence.gui.action;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusDisplay;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPrivateKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.PasswordHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.confluence.gui.action.SnotifyAdminSettingsAction;
import org.apache.commons.lang3.StringUtils;

public class SnotifyPrivateKeystoreSettingsAction
extends SnotifyAdminSettingsAction
implements IValueHandlerProvider {
    private static final long serialVersionUID = -5096387841643437917L;
    private static final String SMIME_PRIVATE_KEYSTORE_LOCATION_ID = "smimePrivateKeystoreLocation";
    private static final String SMIME_PRIVATE_KEYSTORE_PASSWORD_ID = "smimePrivateKeystorePassword";
    private static final String PGP_PRIVATE_KEYSTORE_LOCATION_ID = "pgpPrivateKeystoreLocation";
    private static final String PGP_PRIVATE_KEY_PASSWORD_ID = "pgpPrivateKeyPassword";
    private static final String ACTIVE_TAB_PARAM = "activeTab";
    private static final String VERIFY_BUTTON_PARAM = "Verify settings";
    private static final String CLEAR_CACHE_BUTTON_PARAM = "Clear Cache";
    private static final String SUBMIT_BUTTON_PARAM = "Update";
    private ValueHandlerContainer valueContainer;
    private String verifyMessage;
    private boolean expireKeys;
    private EEncryptionTypePriority typePriority;
    private ECryptographyType lastSubmit;
    private List<String> emails;

    public String doInput() {
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to view global S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.read();
        return "input";
    }

    public String doSubmit() {
        HttpServletRequest request = this.getActiveRequest();
        if (!"POST".equals(request.getMethod())) {
            this.getLog().debug("Access to submit method redirected to input method, as request method wasn't 'POST'. Used method: " + request.getMethod());
            return this.doInput();
        }
        if (!this.hasAdminRights()) {
            ConfluenceUser user = this.getAuthenticatedUser();
            this.getLog().warn("Unauthorized access to submit private S/Notify values from user: {}", (Object)(user != null ? user.getFullName() : "<Unknown User>"));
            return "error";
        }
        this.createValueHandlers();
        this.valueContainer.receive(request);
        this.lastSubmit = this.getSelectedTab(request.getParameter(ACTIVE_TAB_PARAM));
        this.clearCache();
        if (request.getParameter(SUBMIT_BUTTON_PARAM) != null) {
            this.storeSettings();
        } else if (request.getParameter(VERIFY_BUTTON_PARAM) != null) {
            this.verifySettings(this.valueContainer);
        } else if (request.getParameter(CLEAR_CACHE_BUTTON_PARAM) != null) {
            this.expireKeys = true;
        } else {
            this.getLog().error("Unknown submit option used.");
        }
        return "success";
    }

    private void createValueHandlers() {
        if (this.valueContainer != null) {
            return;
        }
        this.valueContainer = new ValueHandlerContainer();
        this.valueContainer.add(new InputHandler(SMIME_PRIVATE_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION));
        this.valueContainer.add(new PasswordHandler(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PRIVATE_SMIME_KEY_PASSWORD));
        this.valueContainer.add(new InputHandler(PGP_PRIVATE_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PRIVATE_PGP_KEYSTORE_LOCATION));
        this.valueContainer.add(new PasswordHandler(PGP_PRIVATE_KEY_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PRIVATE_PGP_KEY_PASSWORD));
    }

    private void storeSettings() {
        this.valueContainer.store();
        this.valueContainer.read();
        this.setShowUpdated(true);
    }

    private void verifySettings(IValueHandlerProvider provider) {
        String pgpPrivateKeystoreLocation;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        String smimePrivateKeystoreLocation = (String)provider.getValue(SMIME_PRIVATE_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((CharSequence)smimePrivateKeystoreLocation)) {
            char[] smimePrivateKeystorePassword = (char[])provider.getValue(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID);
            smimePrivateKeystorePassword = (char[])provider.getValue(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID);
            statusList.addAll(this.verifySmimePrivateKeystore(smimePrivateKeystoreLocation, smimePrivateKeystorePassword));
            SecurityUtil.clearPassword(smimePrivateKeystorePassword);
        }
        if (StringUtils.isNotBlank((CharSequence)(pgpPrivateKeystoreLocation = (String)provider.getValue(PGP_PRIVATE_KEYSTORE_LOCATION_ID)))) {
            char[] pgpPrivateKeyPassword = (char[])provider.getValue(PGP_PRIVATE_KEY_PASSWORD_ID);
            statusList.addAll(this.verifyPgpPrivateKeystore(pgpPrivateKeystoreLocation, pgpPrivateKeyPassword));
            SecurityUtil.clearPassword(pgpPrivateKeyPassword);
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(VerificationStatusDisplay.getHtml(status));
        }
        this.verifyMessage = builder.toString();
    }

    private List<VerificationStatus> verifySmimePrivateKeystore(String smimePrivateKeystoreLocation, char[] smimePrivateKeystorePassword) {
        this.getLog().info("Verifying S/MIME private key store at location: {}", (Object)smimePrivateKeystoreLocation);
        ISnotifyI18n i18n = this.getSnotifyI18n();
        SmimeKeyStoreVerification verification = new SmimeKeyStoreVerification(smimePrivateKeystoreLocation, "PKCS12", i18n);
        verification.getEmails().addAll(this.getEmails());
        verification.setEnablePrivateKeyCheck(true);
        verification.setKeyStorePassword(smimePrivateKeystorePassword);
        verification.setKeyPassword(smimePrivateKeystorePassword);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPrivateKeystore(String pgpPrivateKeystoreLocation, char[] pgpPrivateKeyPassword) {
        this.getLog().info("Verifying PGP private key store at location: {}", (Object)pgpPrivateKeystoreLocation);
        ISnotifyI18n i18n = this.getSnotifyI18n();
        PgpPrivateKeyStoreVerification verification = new PgpPrivateKeyStoreVerification(pgpPrivateKeystoreLocation, i18n);
        verification.getEmails().addAll(this.getEmails());
        verification.setPassword(pgpPrivateKeyPassword);
        return verification.verify();
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
        }
        return this.typePriority;
    }

    private List<String> getEmails() {
        if (this.emails == null) {
            this.emails = new ArrayList<String>();
            String email = this.getMailServerEmail();
            if (email != null) {
                this.emails.add(email);
            }
        }
        return this.emails;
    }

    private String getMailServerEmail() {
        SMTPMailServer mailServer = ((MailServerManager)ComponentLocator.getComponent(MailServerManager.class)).getDefaultSMTPMailServer();
        if (mailServer != null) {
            String mailServerEmail = mailServer.getDefaultFrom();
            this.getLog().debug("Mail addressed used by default mail server: <{}>", (Object)mailServerEmail);
            return mailServerEmail;
        }
        this.getLog().debug("No outgoing mail server registered. Could not determine sending address.");
        return null;
    }

    @Override
    public <T extends IValueHandler<?>> T getValueHandler(String id) {
        return this.valueContainer.getValueHandler(id);
    }

    public boolean isSmimeSelected() {
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERRED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERRED: {
                return false;
            }
        }
        this.getLog().error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected() {
        if (this.lastSubmit == ECryptographyType.PGP) {
            return true;
        }
        if (this.lastSubmit == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERRED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERRED: {
                return true;
            }
        }
        this.getLog().error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public String getActiveTab() {
        if (this.isSmimeSelected()) {
            return ECryptographyType.SMIME.name();
        }
        if (this.isPgpSelected()) {
            return ECryptographyType.PGP.name();
        }
        this.getLog().warn("Unknown tab selected. Defaulting to S/MIME tab.");
        return ECryptographyType.SMIME.name();
    }

    private ECryptographyType getSelectedTab(String tab) {
        try {
            return ECryptographyType.valueOf(tab);
        }
        catch (Exception e) {
            this.getLog().warn("Unknown tab \"" + tab + "\" encountered. Defaulting to S/MIME tab. Error message: " + e.getMessage(), (Throwable)e);
            return ECryptographyType.SMIME;
        }
    }

    public boolean isShowExpireCacheInfo() {
        return this.expireKeys;
    }

    public boolean isShowLeavingPageWarning() {
        return this.verifyMessage != null;
    }

    @HtmlSafe
    public String getVerificationMessage() {
        return this.verifyMessage == null ? "" : this.verifyMessage;
    }
}

