/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.asn1.cmp;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1EncodableVector;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Integer;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1OctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.GeneralName;

public class Challenge
extends ASN1Object {
    private final AlgorithmIdentifier owf;
    private final ASN1OctetString witness;
    private final ASN1OctetString challenge;

    private Challenge(ASN1Sequence seq) {
        int index = 0;
        this.owf = seq.size() == 3 ? AlgorithmIdentifier.getInstance(seq.getObjectAt(index++)) : null;
        this.witness = ASN1OctetString.getInstance(seq.getObjectAt(index++));
        this.challenge = ASN1OctetString.getInstance(seq.getObjectAt(index));
    }

    public Challenge(byte[] witness, byte[] challenge) {
        this(null, witness, challenge);
    }

    public Challenge(AlgorithmIdentifier owf, byte[] witness, byte[] challenge) {
        this.owf = owf;
        this.witness = new DEROctetString(witness);
        this.challenge = new DEROctetString(challenge);
    }

    public static Challenge getInstance(Object o) {
        if (o instanceof Challenge) {
            return (Challenge)o;
        }
        if (o != null) {
            return new Challenge(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    public AlgorithmIdentifier getOwf() {
        return this.owf;
    }

    public byte[] getWitness() {
        return this.witness.getOctets();
    }

    public byte[] getChallenge() {
        return this.challenge.getOctets();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(3);
        this.addOptional(v, this.owf);
        v.add(this.witness);
        v.add(this.challenge);
        return new DERSequence(v);
    }

    private void addOptional(ASN1EncodableVector v, ASN1Encodable obj) {
        if (obj != null) {
            v.add(obj);
        }
    }

    public static class Rand
    extends ASN1Object {
        private final ASN1Integer _int;
        private final GeneralName sender;

        public Rand(ASN1Integer _int, GeneralName sender) {
            this._int = _int;
            this.sender = sender;
        }

        public Rand(ASN1Sequence seq) {
            if (seq.size() != 2) {
                throw new IllegalArgumentException("expected sequence size of 2");
            }
            this._int = ASN1Integer.getInstance(seq.getObjectAt(0));
            this.sender = GeneralName.getInstance(seq.getObjectAt(1));
        }

        public static Rand getInstance(Object o) {
            if (o instanceof Rand) {
                return (Rand)o;
            }
            if (o != null) {
                return new Rand(ASN1Sequence.getInstance(o));
            }
            return null;
        }

        public ASN1Integer getInt() {
            return this._int;
        }

        public GeneralName getSender() {
            return this.sender;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            return new DERSequence(new ASN1Encodable[]{this._int, this.sender});
        }
    }
}

