/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.cmp;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cert.cmp.CMPException;
import net.savignano.thirdparty.org.bouncycastle.cert.cmp.CMPRuntimeException;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculator;
import net.savignano.thirdparty.org.bouncycastle.operator.DigestCalculatorProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;

class CMPUtil {
    CMPUtil() {
    }

    static byte[] calculateCertHash(ASN1Object obj, AlgorithmIdentifier signatureAlgorithm, DigestCalculatorProvider digesterProvider, DigestAlgorithmIdentifierFinder digestAlgFinder) throws CMPException {
        AlgorithmIdentifier digestAlgorithm = digestAlgFinder.find(signatureAlgorithm);
        if (digestAlgorithm == null) {
            throw new CMPException("cannot find digest algorithm from signature algorithm");
        }
        return CMPUtil.calculateDigest(obj, digestAlgorithm, digesterProvider);
    }

    static byte[] calculateDigest(ASN1Object obj, AlgorithmIdentifier digestAlgorithm, DigestCalculatorProvider digesterProvider) throws CMPException {
        DigestCalculator digestCalculator = CMPUtil.getDigestCalculator(digestAlgorithm, digesterProvider);
        CMPUtil.derEncodeToStream(obj, digestCalculator.getOutputStream());
        return digestCalculator.getDigest();
    }

    static void derEncodeToStream(ASN1Object obj, OutputStream stream) {
        try {
            obj.encodeTo(stream, "DER");
            stream.close();
        }
        catch (IOException e) {
            throw new CMPRuntimeException("unable to DER encode object: " + e.getMessage(), e);
        }
    }

    static DigestCalculator getDigestCalculator(AlgorithmIdentifier digestAlgorithm, DigestCalculatorProvider digesterProvider) throws CMPException {
        try {
            return digesterProvider.get(digestAlgorithm);
        }
        catch (OperatorCreationException e) {
            throw new CMPException("unable to create digester: " + e.getMessage(), e);
        }
    }
}

