/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.jcajce;

import java.security.Provider;
import java.security.cert.CertificateException;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cert.X509ContentVerifierProviderBuilder;
import net.savignano.thirdparty.org.bouncycastle.operator.ContentVerifierProvider;
import net.savignano.thirdparty.org.bouncycastle.operator.OperatorCreationException;
import net.savignano.thirdparty.org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;

public class JcaX509ContentVerifierProviderBuilder
implements X509ContentVerifierProviderBuilder {
    private JcaContentVerifierProviderBuilder builder = new JcaContentVerifierProviderBuilder();

    public JcaX509ContentVerifierProviderBuilder setProvider(Provider provider) {
        this.builder.setProvider(provider);
        return this;
    }

    public JcaX509ContentVerifierProviderBuilder setProvider(String providerName) {
        this.builder.setProvider(providerName);
        return this;
    }

    @Override
    public ContentVerifierProvider build(SubjectPublicKeyInfo validatingKeyInfo) throws OperatorCreationException {
        return this.builder.build(validatingKeyInfo);
    }

    @Override
    public ContentVerifierProvider build(X509CertificateHolder validatingKeyInfo) throws OperatorCreationException {
        try {
            return this.builder.build(validatingKeyInfo);
        }
        catch (CertificateException e) {
            throw new OperatorCreationException("Unable to process certificate: " + e.getMessage(), e);
        }
    }
}

